package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.ConnectionId
import scala.jdk.CollectionConverters.*
final case class InboundConnection(
    localDomainInfo: Optional[
      zio.aws.opensearch.model.DomainInformationContainer
    ] = Optional.Absent,
    remoteDomainInfo: Optional[
      zio.aws.opensearch.model.DomainInformationContainer
    ] = Optional.Absent,
    connectionId: Optional[ConnectionId] = Optional.Absent,
    connectionStatus: Optional[
      zio.aws.opensearch.model.InboundConnectionStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.InboundConnection = {
    import InboundConnection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.InboundConnection
      .builder()
      .optionallyWith(localDomainInfo.map(value => value.buildAwsValue()))(
        _.localDomainInfo
      )
      .optionallyWith(remoteDomainInfo.map(value => value.buildAwsValue()))(
        _.remoteDomainInfo
      )
      .optionallyWith(
        connectionId.map(value => ConnectionId.unwrap(value): java.lang.String)
      )(_.connectionId)
      .optionallyWith(connectionStatus.map(value => value.buildAwsValue()))(
        _.connectionStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.InboundConnection.ReadOnly =
    zio.aws.opensearch.model.InboundConnection.wrap(buildAwsValue())
}
object InboundConnection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.InboundConnection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.InboundConnection =
      zio.aws.opensearch.model.InboundConnection(
        localDomainInfo.map(value => value.asEditable),
        remoteDomainInfo.map(value => value.asEditable),
        connectionId.map(value => value),
        connectionStatus.map(value => value.asEditable)
      )
    def localDomainInfo
        : Optional[zio.aws.opensearch.model.DomainInformationContainer.ReadOnly]
    def remoteDomainInfo
        : Optional[zio.aws.opensearch.model.DomainInformationContainer.ReadOnly]
    def connectionId: Optional[ConnectionId]
    def connectionStatus
        : Optional[zio.aws.opensearch.model.InboundConnectionStatus.ReadOnly]
    def getLocalDomainInfo: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.DomainInformationContainer.ReadOnly
    ] = AwsError.unwrapOptionField("localDomainInfo", localDomainInfo)
    def getRemoteDomainInfo: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.DomainInformationContainer.ReadOnly
    ] = AwsError.unwrapOptionField("remoteDomainInfo", remoteDomainInfo)
    def getConnectionId: ZIO[Any, AwsError, ConnectionId] =
      AwsError.unwrapOptionField("connectionId", connectionId)
    def getConnectionStatus: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.InboundConnectionStatus.ReadOnly
    ] = AwsError.unwrapOptionField("connectionStatus", connectionStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.InboundConnection
  ) extends zio.aws.opensearch.model.InboundConnection.ReadOnly {
    override val localDomainInfo: Optional[
      zio.aws.opensearch.model.DomainInformationContainer.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.localDomainInfo())
      .map(value =>
        zio.aws.opensearch.model.DomainInformationContainer.wrap(value)
      )
    override val remoteDomainInfo: Optional[
      zio.aws.opensearch.model.DomainInformationContainer.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.remoteDomainInfo())
      .map(value =>
        zio.aws.opensearch.model.DomainInformationContainer.wrap(value)
      )
    override val connectionId: Optional[ConnectionId] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionId())
      .map(value => zio.aws.opensearch.model.primitives.ConnectionId(value))
    override val connectionStatus
        : Optional[zio.aws.opensearch.model.InboundConnectionStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionStatus())
        .map(value =>
          zio.aws.opensearch.model.InboundConnectionStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.InboundConnection
  ): zio.aws.opensearch.model.InboundConnection.ReadOnly = new Wrapper(impl)
}
