package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDomainNamesRequest(
    engineType: Optional[zio.aws.opensearch.model.EngineType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.ListDomainNamesRequest = {
    import ListDomainNamesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.ListDomainNamesRequest
      .builder()
      .optionallyWith(engineType.map(value => value.unwrap))(_.engineType)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.ListDomainNamesRequest.ReadOnly =
    zio.aws.opensearch.model.ListDomainNamesRequest.wrap(buildAwsValue())
}
object ListDomainNamesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.ListDomainNamesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.ListDomainNamesRequest =
      zio.aws.opensearch.model
        .ListDomainNamesRequest(engineType.map(value => value))
    def engineType: Optional[zio.aws.opensearch.model.EngineType]
    def getEngineType: ZIO[Any, AwsError, zio.aws.opensearch.model.EngineType] =
      AwsError.unwrapOptionField("engineType", engineType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.ListDomainNamesRequest
  ) extends zio.aws.opensearch.model.ListDomainNamesRequest.ReadOnly {
    override val engineType: Optional[zio.aws.opensearch.model.EngineType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engineType())
        .map(value => zio.aws.opensearch.model.EngineType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.ListDomainNamesRequest
  ): zio.aws.opensearch.model.ListDomainNamesRequest.ReadOnly = new Wrapper(
    impl
  )
}
