package zio.aws.opensearch.model
import zio.aws.opensearch.model.primitives.{
  NextToken,
  MaxResults,
  DomainName,
  VersionString
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListInstanceTypeDetailsRequest(
    engineVersion: VersionString,
    domainName: Optional[DomainName] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsRequest = {
    import ListInstanceTypeDetailsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsRequest
      .builder()
      .engineVersion(VersionString.unwrap(engineVersion): java.lang.String)
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.ListInstanceTypeDetailsRequest.ReadOnly =
    zio.aws.opensearch.model.ListInstanceTypeDetailsRequest
      .wrap(buildAwsValue())
}
object ListInstanceTypeDetailsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.ListInstanceTypeDetailsRequest =
      zio.aws.opensearch.model.ListInstanceTypeDetailsRequest(
        engineVersion,
        domainName.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def engineVersion: VersionString
    def domainName: Optional[DomainName]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getEngineVersion: ZIO[Any, Nothing, VersionString] =
      ZIO.succeed(engineVersion)
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsRequest
  ) extends zio.aws.opensearch.model.ListInstanceTypeDetailsRequest.ReadOnly {
    override val engineVersion: VersionString =
      zio.aws.opensearch.model.primitives.VersionString(impl.engineVersion())
    override val domainName: Optional[DomainName] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => zio.aws.opensearch.model.primitives.DomainName(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.opensearch.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.opensearch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsRequest
  ): zio.aws.opensearch.model.ListInstanceTypeDetailsRequest.ReadOnly =
    new Wrapper(impl)
}
