package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.opensearch.model.primitives.ARN
import scala.jdk.CollectionConverters.*
final case class ListTagsRequest(arn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.ListTagsRequest = {
    import ListTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.ListTagsRequest
      .builder()
      .arn(ARN.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.ListTagsRequest.ReadOnly =
    zio.aws.opensearch.model.ListTagsRequest.wrap(buildAwsValue())
}
object ListTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.ListTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.ListTagsRequest =
      zio.aws.opensearch.model.ListTagsRequest(arn)
    def arn: ARN
    def getArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.ListTagsRequest
  ) extends zio.aws.opensearch.model.ListTagsRequest.ReadOnly {
    override val arn: ARN = zio.aws.opensearch.model.primitives.ARN(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.ListTagsRequest
  ): zio.aws.opensearch.model.ListTagsRequest.ReadOnly = new Wrapper(impl)
}
