package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.{NextToken, VersionString}
import scala.jdk.CollectionConverters.*
final case class ListVersionsResponse(
    versions: Optional[Iterable[VersionString]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.ListVersionsResponse = {
    import ListVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.ListVersionsResponse
      .builder()
      .optionallyWith(
        versions.map(value =>
          value.map { item =>
            VersionString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.versions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.ListVersionsResponse.ReadOnly =
    zio.aws.opensearch.model.ListVersionsResponse.wrap(buildAwsValue())
}
object ListVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.ListVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.ListVersionsResponse =
      zio.aws.opensearch.model.ListVersionsResponse(
        versions.map(value => value),
        nextToken.map(value => value)
      )
    def versions: Optional[List[VersionString]]
    def nextToken: Optional[NextToken]
    def getVersions: ZIO[Any, AwsError, List[VersionString]] =
      AwsError.unwrapOptionField("versions", versions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.ListVersionsResponse
  ) extends zio.aws.opensearch.model.ListVersionsResponse.ReadOnly {
    override val versions: Optional[List[VersionString]] = zio.aws.core.internal
      .optionalFromNullable(impl.versions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearch.model.primitives.VersionString(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.opensearch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.ListVersionsResponse
  ): zio.aws.opensearch.model.ListVersionsResponse.ReadOnly = new Wrapper(impl)
}
