package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LogPublishingOptionsStatus(
    options: Optional[Map[
      zio.aws.opensearch.model.LogType,
      zio.aws.opensearch.model.LogPublishingOption
    ]] = Optional.Absent,
    status: Optional[zio.aws.opensearch.model.OptionStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.LogPublishingOptionsStatus = {
    import LogPublishingOptionsStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.LogPublishingOptionsStatus
      .builder()
      .optionallyWith(
        options.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.optionsWithStrings)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.LogPublishingOptionsStatus.ReadOnly =
    zio.aws.opensearch.model.LogPublishingOptionsStatus.wrap(buildAwsValue())
}
object LogPublishingOptionsStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.LogPublishingOptionsStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.LogPublishingOptionsStatus =
      zio.aws.opensearch.model.LogPublishingOptionsStatus(
        options.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        status.map(value => value.asEditable)
      )
    def options: Optional[Map[
      zio.aws.opensearch.model.LogType,
      zio.aws.opensearch.model.LogPublishingOption.ReadOnly
    ]]
    def status: Optional[zio.aws.opensearch.model.OptionStatus.ReadOnly]
    def getOptions: ZIO[Any, AwsError, Map[
      zio.aws.opensearch.model.LogType,
      zio.aws.opensearch.model.LogPublishingOption.ReadOnly
    ]] = AwsError.unwrapOptionField("options", options)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.opensearch.model.OptionStatus.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.LogPublishingOptionsStatus
  ) extends zio.aws.opensearch.model.LogPublishingOptionsStatus.ReadOnly {
    override val options: Optional[Map[
      zio.aws.opensearch.model.LogType,
      zio.aws.opensearch.model.LogPublishingOption.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.options())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.opensearch.model.LogType.wrap(
              key
            ) -> zio.aws.opensearch.model.LogPublishingOption.wrap(value)
          })
          .toMap
      )
    override val status
        : Optional[zio.aws.opensearch.model.OptionStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.opensearch.model.OptionStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.LogPublishingOptionsStatus
  ): zio.aws.opensearch.model.LogPublishingOptionsStatus.ReadOnly = new Wrapper(
    impl
  )
}
