package zio.aws.opensearch.model
import scala.jdk.CollectionConverters.*
sealed trait LogType {
  def unwrap: software.amazon.awssdk.services.opensearch.model.LogType
}
object LogType {
  def wrap(
      value: software.amazon.awssdk.services.opensearch.model.LogType
  ): zio.aws.opensearch.model.LogType = value match {
    case software.amazon.awssdk.services.opensearch.model.LogType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearch.model.LogType.INDEX_SLOW_LOGS =>
      val r = INDEX_SLOW_LOGS
      r
    case software.amazon.awssdk.services.opensearch.model.LogType.SEARCH_SLOW_LOGS =>
      val r = SEARCH_SLOW_LOGS
      r
    case software.amazon.awssdk.services.opensearch.model.LogType.ES_APPLICATION_LOGS =>
      val r = ES_APPLICATION_LOGS
      r
    case software.amazon.awssdk.services.opensearch.model.LogType.AUDIT_LOGS =>
      val r = AUDIT_LOGS
      r
  }
  case object unknownToSdkVersion extends zio.aws.opensearch.model.LogType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.LogType =
      software.amazon.awssdk.services.opensearch.model.LogType.UNKNOWN_TO_SDK_VERSION
  }
  case object INDEX_SLOW_LOGS extends zio.aws.opensearch.model.LogType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.LogType =
      software.amazon.awssdk.services.opensearch.model.LogType.INDEX_SLOW_LOGS
  }
  case object SEARCH_SLOW_LOGS extends zio.aws.opensearch.model.LogType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.LogType =
      software.amazon.awssdk.services.opensearch.model.LogType.SEARCH_SLOW_LOGS
  }
  case object ES_APPLICATION_LOGS extends zio.aws.opensearch.model.LogType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.LogType =
      software.amazon.awssdk.services.opensearch.model.LogType.ES_APPLICATION_LOGS
  }
  case object AUDIT_LOGS extends zio.aws.opensearch.model.LogType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.LogType =
      software.amazon.awssdk.services.opensearch.model.LogType.AUDIT_LOGS
  }
}
