package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class NodeToNodeEncryptionOptionsStatus(
    options: zio.aws.opensearch.model.NodeToNodeEncryptionOptions,
    status: zio.aws.opensearch.model.OptionStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.NodeToNodeEncryptionOptionsStatus = {
    import NodeToNodeEncryptionOptionsStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.NodeToNodeEncryptionOptionsStatus
      .builder()
      .options(options.buildAwsValue())
      .status(status.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.NodeToNodeEncryptionOptionsStatus.ReadOnly =
    zio.aws.opensearch.model.NodeToNodeEncryptionOptionsStatus
      .wrap(buildAwsValue())
}
object NodeToNodeEncryptionOptionsStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.NodeToNodeEncryptionOptionsStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.NodeToNodeEncryptionOptionsStatus =
      zio.aws.opensearch.model.NodeToNodeEncryptionOptionsStatus(
        options.asEditable,
        status.asEditable
      )
    def options: zio.aws.opensearch.model.NodeToNodeEncryptionOptions.ReadOnly
    def status: zio.aws.opensearch.model.OptionStatus.ReadOnly
    def getOptions: ZIO[
      Any,
      Nothing,
      zio.aws.opensearch.model.NodeToNodeEncryptionOptions.ReadOnly
    ] = ZIO.succeed(options)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.opensearch.model.OptionStatus.ReadOnly] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.NodeToNodeEncryptionOptionsStatus
  ) extends zio.aws.opensearch.model.NodeToNodeEncryptionOptionsStatus.ReadOnly {
    override val options
        : zio.aws.opensearch.model.NodeToNodeEncryptionOptions.ReadOnly =
      zio.aws.opensearch.model.NodeToNodeEncryptionOptions.wrap(impl.options())
    override val status: zio.aws.opensearch.model.OptionStatus.ReadOnly =
      zio.aws.opensearch.model.OptionStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.NodeToNodeEncryptionOptionsStatus
  ): zio.aws.opensearch.model.NodeToNodeEncryptionOptionsStatus.ReadOnly =
    new Wrapper(impl)
}
