package zio.aws.opensearch.model
import scala.jdk.CollectionConverters.*
sealed trait OptionState {
  def unwrap: software.amazon.awssdk.services.opensearch.model.OptionState
}
object OptionState {
  def wrap(
      value: software.amazon.awssdk.services.opensearch.model.OptionState
  ): zio.aws.opensearch.model.OptionState = value match {
    case software.amazon.awssdk.services.opensearch.model.OptionState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearch.model.OptionState.REQUIRES_INDEX_DOCUMENTS =>
      val r = RequiresIndexDocuments
      r
    case software.amazon.awssdk.services.opensearch.model.OptionState.PROCESSING =>
      val r = Processing
      r
    case software.amazon.awssdk.services.opensearch.model.OptionState.ACTIVE =>
      val r = Active
      r
  }
  case object unknownToSdkVersion extends zio.aws.opensearch.model.OptionState {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OptionState =
      software.amazon.awssdk.services.opensearch.model.OptionState.UNKNOWN_TO_SDK_VERSION
  }
  case object RequiresIndexDocuments
      extends zio.aws.opensearch.model.OptionState {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OptionState =
      software.amazon.awssdk.services.opensearch.model.OptionState.REQUIRES_INDEX_DOCUMENTS
  }
  case object Processing extends zio.aws.opensearch.model.OptionState {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OptionState =
      software.amazon.awssdk.services.opensearch.model.OptionState.PROCESSING
  }
  case object Active extends zio.aws.opensearch.model.OptionState {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.OptionState =
      software.amazon.awssdk.services.opensearch.model.OptionState.ACTIVE
  }
}
