package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.ConnectionStatusMessage
import scala.jdk.CollectionConverters.*
final case class OutboundConnectionStatus(
    statusCode: Optional[
      zio.aws.opensearch.model.OutboundConnectionStatusCode
    ] = Optional.Absent,
    message: Optional[ConnectionStatusMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatus = {
    import OutboundConnectionStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatus
      .builder()
      .optionallyWith(statusCode.map(value => value.unwrap))(_.statusCode)
      .optionallyWith(
        message.map(value =>
          ConnectionStatusMessage.unwrap(value): java.lang.String
        )
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.OutboundConnectionStatus.ReadOnly =
    zio.aws.opensearch.model.OutboundConnectionStatus.wrap(buildAwsValue())
}
object OutboundConnectionStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.OutboundConnectionStatus =
      zio.aws.opensearch.model.OutboundConnectionStatus(
        statusCode.map(value => value),
        message.map(value => value)
      )
    def statusCode
        : Optional[zio.aws.opensearch.model.OutboundConnectionStatusCode]
    def message: Optional[ConnectionStatusMessage]
    def getStatusCode: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.OutboundConnectionStatusCode
    ] = AwsError.unwrapOptionField("statusCode", statusCode)
    def getMessage: ZIO[Any, AwsError, ConnectionStatusMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatus
  ) extends zio.aws.opensearch.model.OutboundConnectionStatus.ReadOnly {
    override val statusCode
        : Optional[zio.aws.opensearch.model.OutboundConnectionStatusCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusCode())
        .map(value =>
          zio.aws.opensearch.model.OutboundConnectionStatusCode.wrap(value)
        )
    override val message: Optional[ConnectionStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.message())
        .map(value =>
          zio.aws.opensearch.model.primitives.ConnectionStatusMessage(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatus
  ): zio.aws.opensearch.model.OutboundConnectionStatus.ReadOnly = new Wrapper(
    impl
  )
}
