package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.{S3Key, S3BucketName}
import scala.jdk.CollectionConverters.*
final case class PackageSource(
    s3BucketName: Optional[S3BucketName] = Optional.Absent,
    s3Key: Optional[S3Key] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.PackageSource = {
    import PackageSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.PackageSource
      .builder()
      .optionallyWith(
        s3BucketName.map(value => S3BucketName.unwrap(value): java.lang.String)
      )(_.s3BucketName)
      .optionallyWith(
        s3Key.map(value => S3Key.unwrap(value): java.lang.String)
      )(_.s3Key)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.PackageSource.ReadOnly =
    zio.aws.opensearch.model.PackageSource.wrap(buildAwsValue())
}
object PackageSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.PackageSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.PackageSource =
      zio.aws.opensearch.model.PackageSource(
        s3BucketName.map(value => value),
        s3Key.map(value => value)
      )
    def s3BucketName: Optional[S3BucketName]
    def s3Key: Optional[S3Key]
    def getS3BucketName: ZIO[Any, AwsError, S3BucketName] =
      AwsError.unwrapOptionField("s3BucketName", s3BucketName)
    def getS3Key: ZIO[Any, AwsError, S3Key] =
      AwsError.unwrapOptionField("s3Key", s3Key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.PackageSource
  ) extends zio.aws.opensearch.model.PackageSource.ReadOnly {
    override val s3BucketName: Optional[S3BucketName] = zio.aws.core.internal
      .optionalFromNullable(impl.s3BucketName())
      .map(value => zio.aws.opensearch.model.primitives.S3BucketName(value))
    override val s3Key: Optional[S3Key] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Key())
      .map(value => zio.aws.opensearch.model.primitives.S3Key(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.PackageSource
  ): zio.aws.opensearch.model.PackageSource.ReadOnly = new Wrapper(impl)
}
