package zio.aws.opensearch.model
import scala.jdk.CollectionConverters.*
sealed trait PackageStatus {
  def unwrap: software.amazon.awssdk.services.opensearch.model.PackageStatus
}
object PackageStatus {
  def wrap(
      value: software.amazon.awssdk.services.opensearch.model.PackageStatus
  ): zio.aws.opensearch.model.PackageStatus = value match {
    case software.amazon.awssdk.services.opensearch.model.PackageStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearch.model.PackageStatus.COPYING =>
      val r = COPYING
      r
    case software.amazon.awssdk.services.opensearch.model.PackageStatus.COPY_FAILED =>
      val r = COPY_FAILED
      r
    case software.amazon.awssdk.services.opensearch.model.PackageStatus.VALIDATING =>
      val r = VALIDATING
      r
    case software.amazon.awssdk.services.opensearch.model.PackageStatus.VALIDATION_FAILED =>
      val r = VALIDATION_FAILED
      r
    case software.amazon.awssdk.services.opensearch.model.PackageStatus.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.opensearch.model.PackageStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.opensearch.model.PackageStatus.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.opensearch.model.PackageStatus.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.opensearch.model.PackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.PackageStatus =
      software.amazon.awssdk.services.opensearch.model.PackageStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object COPYING extends zio.aws.opensearch.model.PackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.PackageStatus =
      software.amazon.awssdk.services.opensearch.model.PackageStatus.COPYING
  }
  case object COPY_FAILED extends zio.aws.opensearch.model.PackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.PackageStatus =
      software.amazon.awssdk.services.opensearch.model.PackageStatus.COPY_FAILED
  }
  case object VALIDATING extends zio.aws.opensearch.model.PackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.PackageStatus =
      software.amazon.awssdk.services.opensearch.model.PackageStatus.VALIDATING
  }
  case object VALIDATION_FAILED extends zio.aws.opensearch.model.PackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.PackageStatus =
      software.amazon.awssdk.services.opensearch.model.PackageStatus.VALIDATION_FAILED
  }
  case object AVAILABLE extends zio.aws.opensearch.model.PackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.PackageStatus =
      software.amazon.awssdk.services.opensearch.model.PackageStatus.AVAILABLE
  }
  case object DELETING extends zio.aws.opensearch.model.PackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.PackageStatus =
      software.amazon.awssdk.services.opensearch.model.PackageStatus.DELETING
  }
  case object DELETED extends zio.aws.opensearch.model.PackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.PackageStatus =
      software.amazon.awssdk.services.opensearch.model.PackageStatus.DELETED
  }
  case object DELETE_FAILED extends zio.aws.opensearch.model.PackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.PackageStatus =
      software.amazon.awssdk.services.opensearch.model.PackageStatus.DELETE_FAILED
  }
}
