package zio.aws.opensearch.model
import scala.jdk.CollectionConverters.*
sealed trait PackageType {
  def unwrap: software.amazon.awssdk.services.opensearch.model.PackageType
}
object PackageType {
  def wrap(
      value: software.amazon.awssdk.services.opensearch.model.PackageType
  ): zio.aws.opensearch.model.PackageType = value match {
    case software.amazon.awssdk.services.opensearch.model.PackageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearch.model.PackageType.TXT_DICTIONARY =>
      val r = `TXT-DICTIONARY`
      r
  }
  case object unknownToSdkVersion extends zio.aws.opensearch.model.PackageType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.PackageType =
      software.amazon.awssdk.services.opensearch.model.PackageType.UNKNOWN_TO_SDK_VERSION
  }
  case object `TXT-DICTIONARY` extends zio.aws.opensearch.model.PackageType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.PackageType =
      software.amazon.awssdk.services.opensearch.model.PackageType.TXT_DICTIONARY
  }
}
