package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.{ReservationToken, GUID}
import scala.jdk.CollectionConverters.*
final case class PurchaseReservedInstanceOfferingResponse(
    reservedInstanceId: Optional[GUID] = Optional.Absent,
    reservationName: Optional[ReservationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.PurchaseReservedInstanceOfferingResponse = {
    import PurchaseReservedInstanceOfferingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.PurchaseReservedInstanceOfferingResponse
      .builder()
      .optionallyWith(
        reservedInstanceId.map(value => GUID.unwrap(value): java.lang.String)
      )(_.reservedInstanceId)
      .optionallyWith(
        reservationName.map(value =>
          ReservationToken.unwrap(value): java.lang.String
        )
      )(_.reservationName)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.PurchaseReservedInstanceOfferingResponse.ReadOnly =
    zio.aws.opensearch.model.PurchaseReservedInstanceOfferingResponse
      .wrap(buildAwsValue())
}
object PurchaseReservedInstanceOfferingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.PurchaseReservedInstanceOfferingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearch.model.PurchaseReservedInstanceOfferingResponse =
      zio.aws.opensearch.model.PurchaseReservedInstanceOfferingResponse(
        reservedInstanceId.map(value => value),
        reservationName.map(value => value)
      )
    def reservedInstanceId: Optional[GUID]
    def reservationName: Optional[ReservationToken]
    def getReservedInstanceId: ZIO[Any, AwsError, GUID] =
      AwsError.unwrapOptionField("reservedInstanceId", reservedInstanceId)
    def getReservationName: ZIO[Any, AwsError, ReservationToken] =
      AwsError.unwrapOptionField("reservationName", reservationName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.PurchaseReservedInstanceOfferingResponse
  ) extends zio.aws.opensearch.model.PurchaseReservedInstanceOfferingResponse.ReadOnly {
    override val reservedInstanceId: Optional[GUID] = zio.aws.core.internal
      .optionalFromNullable(impl.reservedInstanceId())
      .map(value => zio.aws.opensearch.model.primitives.GUID(value))
    override val reservationName: Optional[ReservationToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservationName())
        .map(value =>
          zio.aws.opensearch.model.primitives.ReservationToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.PurchaseReservedInstanceOfferingResponse
  ): zio.aws.opensearch.model.PurchaseReservedInstanceOfferingResponse.ReadOnly =
    new Wrapper(impl)
}
