package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.opensearch.model.primitives.ConnectionId
import scala.jdk.CollectionConverters.*
final case class RejectInboundConnectionRequest(connectionId: ConnectionId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.RejectInboundConnectionRequest = {
    import RejectInboundConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.RejectInboundConnectionRequest
      .builder()
      .connectionId(ConnectionId.unwrap(connectionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.RejectInboundConnectionRequest.ReadOnly =
    zio.aws.opensearch.model.RejectInboundConnectionRequest
      .wrap(buildAwsValue())
}
object RejectInboundConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.RejectInboundConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.RejectInboundConnectionRequest =
      zio.aws.opensearch.model.RejectInboundConnectionRequest(connectionId)
    def connectionId: ConnectionId
    def getConnectionId: ZIO[Any, Nothing, ConnectionId] =
      ZIO.succeed(connectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.RejectInboundConnectionRequest
  ) extends zio.aws.opensearch.model.RejectInboundConnectionRequest.ReadOnly {
    override val connectionId: ConnectionId =
      zio.aws.opensearch.model.primitives.ConnectionId(impl.connectionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.RejectInboundConnectionRequest
  ): zio.aws.opensearch.model.RejectInboundConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
