package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RejectInboundConnectionResponse(
    connection: Optional[zio.aws.opensearch.model.InboundConnection] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.RejectInboundConnectionResponse = {
    import RejectInboundConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.RejectInboundConnectionResponse
      .builder()
      .optionallyWith(connection.map(value => value.buildAwsValue()))(
        _.connection
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.RejectInboundConnectionResponse.ReadOnly =
    zio.aws.opensearch.model.RejectInboundConnectionResponse
      .wrap(buildAwsValue())
}
object RejectInboundConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.RejectInboundConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.RejectInboundConnectionResponse =
      zio.aws.opensearch.model.RejectInboundConnectionResponse(
        connection.map(value => value.asEditable)
      )
    def connection
        : Optional[zio.aws.opensearch.model.InboundConnection.ReadOnly]
    def getConnection: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.InboundConnection.ReadOnly
    ] = AwsError.unwrapOptionField("connection", connection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.RejectInboundConnectionResponse
  ) extends zio.aws.opensearch.model.RejectInboundConnectionResponse.ReadOnly {
    override val connection
        : Optional[zio.aws.opensearch.model.InboundConnection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connection())
        .map(value => zio.aws.opensearch.model.InboundConnection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.RejectInboundConnectionResponse
  ): zio.aws.opensearch.model.RejectInboundConnectionResponse.ReadOnly =
    new Wrapper(impl)
}
