package zio.aws.opensearch.model
import zio.aws.opensearch.model.primitives.{
  Integer,
  UpdateTimestamp,
  GUID,
  ReservationToken
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ReservedInstance(
    reservationName: Optional[ReservationToken] = Optional.Absent,
    reservedInstanceId: Optional[GUID] = Optional.Absent,
    billingSubscriptionId: Optional[Long] = Optional.Absent,
    reservedInstanceOfferingId: Optional[String] = Optional.Absent,
    instanceType: Optional[
      zio.aws.opensearch.model.OpenSearchPartitionInstanceType
    ] = Optional.Absent,
    startTime: Optional[UpdateTimestamp] = Optional.Absent,
    duration: Optional[Integer] = Optional.Absent,
    fixedPrice: Optional[Double] = Optional.Absent,
    usagePrice: Optional[Double] = Optional.Absent,
    currencyCode: Optional[String] = Optional.Absent,
    instanceCount: Optional[Integer] = Optional.Absent,
    state: Optional[String] = Optional.Absent,
    paymentOption: Optional[
      zio.aws.opensearch.model.ReservedInstancePaymentOption
    ] = Optional.Absent,
    recurringCharges: Optional[
      Iterable[zio.aws.opensearch.model.RecurringCharge]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.ReservedInstance = {
    import ReservedInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.ReservedInstance
      .builder()
      .optionallyWith(
        reservationName.map(value =>
          ReservationToken.unwrap(value): java.lang.String
        )
      )(_.reservationName)
      .optionallyWith(
        reservedInstanceId.map(value => GUID.unwrap(value): java.lang.String)
      )(_.reservedInstanceId)
      .optionallyWith(
        billingSubscriptionId.map(value => value: java.lang.Long)
      )(_.billingSubscriptionId)
      .optionallyWith(
        reservedInstanceOfferingId.map(value => value: java.lang.String)
      )(_.reservedInstanceOfferingId)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(
        startTime.map(value => UpdateTimestamp.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(duration.map(value => value: java.lang.Integer))(
        _.duration
      )
      .optionallyWith(fixedPrice.map(value => value: java.lang.Double))(
        _.fixedPrice
      )
      .optionallyWith(usagePrice.map(value => value: java.lang.Double))(
        _.usagePrice
      )
      .optionallyWith(currencyCode.map(value => value: java.lang.String))(
        _.currencyCode
      )
      .optionallyWith(instanceCount.map(value => value: java.lang.Integer))(
        _.instanceCount
      )
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .optionallyWith(paymentOption.map(value => value.unwrap))(_.paymentOption)
      .optionallyWith(
        recurringCharges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recurringCharges)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.ReservedInstance.ReadOnly =
    zio.aws.opensearch.model.ReservedInstance.wrap(buildAwsValue())
}
object ReservedInstance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.ReservedInstance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.ReservedInstance =
      zio.aws.opensearch.model.ReservedInstance(
        reservationName.map(value => value),
        reservedInstanceId.map(value => value),
        billingSubscriptionId.map(value => value),
        reservedInstanceOfferingId.map(value => value),
        instanceType.map(value => value),
        startTime.map(value => value),
        duration.map(value => value),
        fixedPrice.map(value => value),
        usagePrice.map(value => value),
        currencyCode.map(value => value),
        instanceCount.map(value => value),
        state.map(value => value),
        paymentOption.map(value => value),
        recurringCharges.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def reservationName: Optional[ReservationToken]
    def reservedInstanceId: Optional[GUID]
    def billingSubscriptionId: Optional[Long]
    def reservedInstanceOfferingId: Optional[String]
    def instanceType
        : Optional[zio.aws.opensearch.model.OpenSearchPartitionInstanceType]
    def startTime: Optional[UpdateTimestamp]
    def duration: Optional[Integer]
    def fixedPrice: Optional[Double]
    def usagePrice: Optional[Double]
    def currencyCode: Optional[String]
    def instanceCount: Optional[Integer]
    def state: Optional[String]
    def paymentOption
        : Optional[zio.aws.opensearch.model.ReservedInstancePaymentOption]
    def recurringCharges
        : Optional[List[zio.aws.opensearch.model.RecurringCharge.ReadOnly]]
    def getReservationName: ZIO[Any, AwsError, ReservationToken] =
      AwsError.unwrapOptionField("reservationName", reservationName)
    def getReservedInstanceId: ZIO[Any, AwsError, GUID] =
      AwsError.unwrapOptionField("reservedInstanceId", reservedInstanceId)
    def getBillingSubscriptionId: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("billingSubscriptionId", billingSubscriptionId)
    def getReservedInstanceOfferingId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "reservedInstanceOfferingId",
        reservedInstanceOfferingId
      )
    def getInstanceType: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.OpenSearchPartitionInstanceType
    ] = AwsError.unwrapOptionField("instanceType", instanceType)
    def getStartTime: ZIO[Any, AwsError, UpdateTimestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getDuration: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("duration", duration)
    def getFixedPrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("fixedPrice", fixedPrice)
    def getUsagePrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("usagePrice", usagePrice)
    def getCurrencyCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("currencyCode", currencyCode)
    def getInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("state", state)
    def getPaymentOption: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.ReservedInstancePaymentOption
    ] = AwsError.unwrapOptionField("paymentOption", paymentOption)
    def getRecurringCharges: ZIO[Any, AwsError, List[
      zio.aws.opensearch.model.RecurringCharge.ReadOnly
    ]] = AwsError.unwrapOptionField("recurringCharges", recurringCharges)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.ReservedInstance
  ) extends zio.aws.opensearch.model.ReservedInstance.ReadOnly {
    override val reservationName: Optional[ReservationToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservationName())
        .map(value =>
          zio.aws.opensearch.model.primitives.ReservationToken(value)
        )
    override val reservedInstanceId: Optional[GUID] = zio.aws.core.internal
      .optionalFromNullable(impl.reservedInstanceId())
      .map(value => zio.aws.opensearch.model.primitives.GUID(value))
    override val billingSubscriptionId: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.billingSubscriptionId())
      .map(value => value: Long)
    override val reservedInstanceOfferingId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedInstanceOfferingId())
        .map(value => value: String)
    override val instanceType
        : Optional[zio.aws.opensearch.model.OpenSearchPartitionInstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value =>
          zio.aws.opensearch.model.OpenSearchPartitionInstanceType.wrap(value)
        )
    override val startTime: Optional[UpdateTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.opensearch.model.primitives.UpdateTimestamp(value))
    override val duration: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.duration())
      .map(value => value: Integer)
    override val fixedPrice: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.fixedPrice())
      .map(value => value: Double)
    override val usagePrice: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.usagePrice())
      .map(value => value: Double)
    override val currencyCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.currencyCode())
      .map(value => value: String)
    override val instanceCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceCount())
      .map(value => value: Integer)
    override val state: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value => value: String)
    override val paymentOption
        : Optional[zio.aws.opensearch.model.ReservedInstancePaymentOption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.paymentOption())
        .map(value =>
          zio.aws.opensearch.model.ReservedInstancePaymentOption.wrap(value)
        )
    override val recurringCharges
        : Optional[List[zio.aws.opensearch.model.RecurringCharge.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recurringCharges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opensearch.model.RecurringCharge.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.ReservedInstance
  ): zio.aws.opensearch.model.ReservedInstance.ReadOnly = new Wrapper(impl)
}
