package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.opensearch.model.primitives.{SAMLEntityId, SAMLMetadata}
import scala.jdk.CollectionConverters.*
final case class SAMLIdp(
    metadataContent: SAMLMetadata,
    entityId: SAMLEntityId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.SAMLIdp = {
    import SAMLIdp.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.SAMLIdp
      .builder()
      .metadataContent(SAMLMetadata.unwrap(metadataContent): java.lang.String)
      .entityId(SAMLEntityId.unwrap(entityId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.SAMLIdp.ReadOnly =
    zio.aws.opensearch.model.SAMLIdp.wrap(buildAwsValue())
}
object SAMLIdp {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.SAMLIdp
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.SAMLIdp =
      zio.aws.opensearch.model.SAMLIdp(metadataContent, entityId)
    def metadataContent: SAMLMetadata
    def entityId: SAMLEntityId
    def getMetadataContent: ZIO[Any, Nothing, SAMLMetadata] =
      ZIO.succeed(metadataContent)
    def getEntityId: ZIO[Any, Nothing, SAMLEntityId] = ZIO.succeed(entityId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.SAMLIdp
  ) extends zio.aws.opensearch.model.SAMLIdp.ReadOnly {
    override val metadataContent: SAMLMetadata =
      zio.aws.opensearch.model.primitives.SAMLMetadata(impl.metadataContent())
    override val entityId: SAMLEntityId =
      zio.aws.opensearch.model.primitives.SAMLEntityId(impl.entityId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.SAMLIdp
  ): zio.aws.opensearch.model.SAMLIdp.ReadOnly = new Wrapper(impl)
}
