package zio.aws.opensearch.model
import zio.aws.opensearch.model.primitives.{
  ScheduledAutoTuneDescription,
  AutoTuneDate
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ScheduledAutoTuneDetails(
    date: Optional[AutoTuneDate] = Optional.Absent,
    actionType: Optional[zio.aws.opensearch.model.ScheduledAutoTuneActionType] =
      Optional.Absent,
    action: Optional[ScheduledAutoTuneDescription] = Optional.Absent,
    severity: Optional[zio.aws.opensearch.model.ScheduledAutoTuneSeverityType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.ScheduledAutoTuneDetails = {
    import ScheduledAutoTuneDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.ScheduledAutoTuneDetails
      .builder()
      .optionallyWith(date.map(value => AutoTuneDate.unwrap(value): Instant))(
        _.date
      )
      .optionallyWith(actionType.map(value => value.unwrap))(_.actionType)
      .optionallyWith(
        action.map(value =>
          ScheduledAutoTuneDescription.unwrap(value): java.lang.String
        )
      )(_.action)
      .optionallyWith(severity.map(value => value.unwrap))(_.severity)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.ScheduledAutoTuneDetails.ReadOnly =
    zio.aws.opensearch.model.ScheduledAutoTuneDetails.wrap(buildAwsValue())
}
object ScheduledAutoTuneDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.ScheduledAutoTuneDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.ScheduledAutoTuneDetails =
      zio.aws.opensearch.model.ScheduledAutoTuneDetails(
        date.map(value => value),
        actionType.map(value => value),
        action.map(value => value),
        severity.map(value => value)
      )
    def date: Optional[AutoTuneDate]
    def actionType
        : Optional[zio.aws.opensearch.model.ScheduledAutoTuneActionType]
    def action: Optional[ScheduledAutoTuneDescription]
    def severity
        : Optional[zio.aws.opensearch.model.ScheduledAutoTuneSeverityType]
    def getDate: ZIO[Any, AwsError, AutoTuneDate] =
      AwsError.unwrapOptionField("date", date)
    def getActionType: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.ScheduledAutoTuneActionType
    ] = AwsError.unwrapOptionField("actionType", actionType)
    def getAction: ZIO[Any, AwsError, ScheduledAutoTuneDescription] =
      AwsError.unwrapOptionField("action", action)
    def getSeverity: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.ScheduledAutoTuneSeverityType
    ] = AwsError.unwrapOptionField("severity", severity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.ScheduledAutoTuneDetails
  ) extends zio.aws.opensearch.model.ScheduledAutoTuneDetails.ReadOnly {
    override val date: Optional[AutoTuneDate] = zio.aws.core.internal
      .optionalFromNullable(impl.date())
      .map(value => zio.aws.opensearch.model.primitives.AutoTuneDate(value))
    override val actionType
        : Optional[zio.aws.opensearch.model.ScheduledAutoTuneActionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionType())
        .map(value =>
          zio.aws.opensearch.model.ScheduledAutoTuneActionType.wrap(value)
        )
    override val action: Optional[ScheduledAutoTuneDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value =>
          zio.aws.opensearch.model.primitives
            .ScheduledAutoTuneDescription(value)
        )
    override val severity
        : Optional[zio.aws.opensearch.model.ScheduledAutoTuneSeverityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severity())
        .map(value =>
          zio.aws.opensearch.model.ScheduledAutoTuneSeverityType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.ScheduledAutoTuneDetails
  ): zio.aws.opensearch.model.ScheduledAutoTuneDetails.ReadOnly = new Wrapper(
    impl
  )
}
