package zio.aws.opensearch.model
import zio.aws.opensearch.model.primitives.IntegerClass
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SnapshotOptions(
    automatedSnapshotStartHour: Optional[IntegerClass] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.SnapshotOptions = {
    import SnapshotOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.SnapshotOptions
      .builder()
      .optionallyWith(
        automatedSnapshotStartHour.map(value =>
          IntegerClass.unwrap(value): Integer
        )
      )(_.automatedSnapshotStartHour)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.SnapshotOptions.ReadOnly =
    zio.aws.opensearch.model.SnapshotOptions.wrap(buildAwsValue())
}
object SnapshotOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.SnapshotOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.SnapshotOptions =
      zio.aws.opensearch.model
        .SnapshotOptions(automatedSnapshotStartHour.map(value => value))
    def automatedSnapshotStartHour: Optional[IntegerClass]
    def getAutomatedSnapshotStartHour: ZIO[Any, AwsError, IntegerClass] =
      AwsError.unwrapOptionField(
        "automatedSnapshotStartHour",
        automatedSnapshotStartHour
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.SnapshotOptions
  ) extends zio.aws.opensearch.model.SnapshotOptions.ReadOnly {
    override val automatedSnapshotStartHour: Optional[IntegerClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.automatedSnapshotStartHour())
        .map(value => zio.aws.opensearch.model.primitives.IntegerClass(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.SnapshotOptions
  ): zio.aws.opensearch.model.SnapshotOptions.ReadOnly = new Wrapper(impl)
}
