package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SnapshotOptionsStatus(
    options: zio.aws.opensearch.model.SnapshotOptions,
    status: zio.aws.opensearch.model.OptionStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.SnapshotOptionsStatus = {
    import SnapshotOptionsStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.SnapshotOptionsStatus
      .builder()
      .options(options.buildAwsValue())
      .status(status.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.SnapshotOptionsStatus.ReadOnly =
    zio.aws.opensearch.model.SnapshotOptionsStatus.wrap(buildAwsValue())
}
object SnapshotOptionsStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.SnapshotOptionsStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.SnapshotOptionsStatus =
      zio.aws.opensearch.model
        .SnapshotOptionsStatus(options.asEditable, status.asEditable)
    def options: zio.aws.opensearch.model.SnapshotOptions.ReadOnly
    def status: zio.aws.opensearch.model.OptionStatus.ReadOnly
    def getOptions
        : ZIO[Any, Nothing, zio.aws.opensearch.model.SnapshotOptions.ReadOnly] =
      ZIO.succeed(options)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.opensearch.model.OptionStatus.ReadOnly] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.SnapshotOptionsStatus
  ) extends zio.aws.opensearch.model.SnapshotOptionsStatus.ReadOnly {
    override val options: zio.aws.opensearch.model.SnapshotOptions.ReadOnly =
      zio.aws.opensearch.model.SnapshotOptions.wrap(impl.options())
    override val status: zio.aws.opensearch.model.OptionStatus.ReadOnly =
      zio.aws.opensearch.model.OptionStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.SnapshotOptionsStatus
  ): zio.aws.opensearch.model.SnapshotOptionsStatus.ReadOnly = new Wrapper(impl)
}
