package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.opensearch.model.primitives.DomainName
import scala.jdk.CollectionConverters.*
final case class StartServiceSoftwareUpdateRequest(domainName: DomainName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.StartServiceSoftwareUpdateRequest = {
    import StartServiceSoftwareUpdateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.StartServiceSoftwareUpdateRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.StartServiceSoftwareUpdateRequest.ReadOnly =
    zio.aws.opensearch.model.StartServiceSoftwareUpdateRequest
      .wrap(buildAwsValue())
}
object StartServiceSoftwareUpdateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.StartServiceSoftwareUpdateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.StartServiceSoftwareUpdateRequest =
      zio.aws.opensearch.model.StartServiceSoftwareUpdateRequest(domainName)
    def domainName: DomainName
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.StartServiceSoftwareUpdateRequest
  ) extends zio.aws.opensearch.model.StartServiceSoftwareUpdateRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.opensearch.model.primitives.DomainName(impl.domainName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.StartServiceSoftwareUpdateRequest
  ): zio.aws.opensearch.model.StartServiceSoftwareUpdateRequest.ReadOnly =
    new Wrapper(impl)
}
