package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.{StorageSubTypeName, StorageTypeName}
import scala.jdk.CollectionConverters.*
final case class StorageType(
    storageTypeName: Optional[StorageTypeName] = Optional.Absent,
    storageSubTypeName: Optional[StorageSubTypeName] = Optional.Absent,
    storageTypeLimits: Optional[
      Iterable[zio.aws.opensearch.model.StorageTypeLimit]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.StorageType = {
    import StorageType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.StorageType
      .builder()
      .optionallyWith(
        storageTypeName.map(value =>
          StorageTypeName.unwrap(value): java.lang.String
        )
      )(_.storageTypeName)
      .optionallyWith(
        storageSubTypeName.map(value =>
          StorageSubTypeName.unwrap(value): java.lang.String
        )
      )(_.storageSubTypeName)
      .optionallyWith(
        storageTypeLimits.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.storageTypeLimits)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.StorageType.ReadOnly =
    zio.aws.opensearch.model.StorageType.wrap(buildAwsValue())
}
object StorageType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.StorageType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.StorageType =
      zio.aws.opensearch.model.StorageType(
        storageTypeName.map(value => value),
        storageSubTypeName.map(value => value),
        storageTypeLimits.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def storageTypeName: Optional[StorageTypeName]
    def storageSubTypeName: Optional[StorageSubTypeName]
    def storageTypeLimits
        : Optional[List[zio.aws.opensearch.model.StorageTypeLimit.ReadOnly]]
    def getStorageTypeName: ZIO[Any, AwsError, StorageTypeName] =
      AwsError.unwrapOptionField("storageTypeName", storageTypeName)
    def getStorageSubTypeName: ZIO[Any, AwsError, StorageSubTypeName] =
      AwsError.unwrapOptionField("storageSubTypeName", storageSubTypeName)
    def getStorageTypeLimits: ZIO[Any, AwsError, List[
      zio.aws.opensearch.model.StorageTypeLimit.ReadOnly
    ]] = AwsError.unwrapOptionField("storageTypeLimits", storageTypeLimits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.StorageType
  ) extends zio.aws.opensearch.model.StorageType.ReadOnly {
    override val storageTypeName: Optional[StorageTypeName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageTypeName())
        .map(value =>
          zio.aws.opensearch.model.primitives.StorageTypeName(value)
        )
    override val storageSubTypeName: Optional[StorageSubTypeName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageSubTypeName())
        .map(value =>
          zio.aws.opensearch.model.primitives.StorageSubTypeName(value)
        )
    override val storageTypeLimits
        : Optional[List[zio.aws.opensearch.model.StorageTypeLimit.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageTypeLimits())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opensearch.model.StorageTypeLimit.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.StorageType
  ): zio.aws.opensearch.model.StorageType.ReadOnly = new Wrapper(impl)
}
