package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.{
  CommitMessage,
  PackageDescription,
  PackageID
}
import scala.jdk.CollectionConverters.*
final case class UpdatePackageRequest(
    packageID: PackageID,
    packageSource: zio.aws.opensearch.model.PackageSource,
    packageDescription: Optional[PackageDescription] = Optional.Absent,
    commitMessage: Optional[CommitMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.UpdatePackageRequest = {
    import UpdatePackageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.UpdatePackageRequest
      .builder()
      .packageID(PackageID.unwrap(packageID): java.lang.String)
      .packageSource(packageSource.buildAwsValue())
      .optionallyWith(
        packageDescription.map(value =>
          PackageDescription.unwrap(value): java.lang.String
        )
      )(_.packageDescription)
      .optionallyWith(
        commitMessage.map(value =>
          CommitMessage.unwrap(value): java.lang.String
        )
      )(_.commitMessage)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.UpdatePackageRequest.ReadOnly =
    zio.aws.opensearch.model.UpdatePackageRequest.wrap(buildAwsValue())
}
object UpdatePackageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.UpdatePackageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.UpdatePackageRequest =
      zio.aws.opensearch.model.UpdatePackageRequest(
        packageID,
        packageSource.asEditable,
        packageDescription.map(value => value),
        commitMessage.map(value => value)
      )
    def packageID: PackageID
    def packageSource: zio.aws.opensearch.model.PackageSource.ReadOnly
    def packageDescription: Optional[PackageDescription]
    def commitMessage: Optional[CommitMessage]
    def getPackageID: ZIO[Any, Nothing, PackageID] = ZIO.succeed(packageID)
    def getPackageSource
        : ZIO[Any, Nothing, zio.aws.opensearch.model.PackageSource.ReadOnly] =
      ZIO.succeed(packageSource)
    def getPackageDescription: ZIO[Any, AwsError, PackageDescription] =
      AwsError.unwrapOptionField("packageDescription", packageDescription)
    def getCommitMessage: ZIO[Any, AwsError, CommitMessage] =
      AwsError.unwrapOptionField("commitMessage", commitMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.UpdatePackageRequest
  ) extends zio.aws.opensearch.model.UpdatePackageRequest.ReadOnly {
    override val packageID: PackageID =
      zio.aws.opensearch.model.primitives.PackageID(impl.packageID())
    override val packageSource
        : zio.aws.opensearch.model.PackageSource.ReadOnly =
      zio.aws.opensearch.model.PackageSource.wrap(impl.packageSource())
    override val packageDescription: Optional[PackageDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packageDescription())
        .map(value =>
          zio.aws.opensearch.model.primitives.PackageDescription(value)
        )
    override val commitMessage: Optional[CommitMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.commitMessage())
      .map(value => zio.aws.opensearch.model.primitives.CommitMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.UpdatePackageRequest
  ): zio.aws.opensearch.model.UpdatePackageRequest.ReadOnly = new Wrapper(impl)
}
