package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdatePackageResponse(
    packageDetails: Optional[zio.aws.opensearch.model.PackageDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.UpdatePackageResponse = {
    import UpdatePackageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.UpdatePackageResponse
      .builder()
      .optionallyWith(packageDetails.map(value => value.buildAwsValue()))(
        _.packageDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.UpdatePackageResponse.ReadOnly =
    zio.aws.opensearch.model.UpdatePackageResponse.wrap(buildAwsValue())
}
object UpdatePackageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.UpdatePackageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.UpdatePackageResponse =
      zio.aws.opensearch.model
        .UpdatePackageResponse(packageDetails.map(value => value.asEditable))
    def packageDetails
        : Optional[zio.aws.opensearch.model.PackageDetails.ReadOnly]
    def getPackageDetails
        : ZIO[Any, AwsError, zio.aws.opensearch.model.PackageDetails.ReadOnly] =
      AwsError.unwrapOptionField("packageDetails", packageDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.UpdatePackageResponse
  ) extends zio.aws.opensearch.model.UpdatePackageResponse.ReadOnly {
    override val packageDetails
        : Optional[zio.aws.opensearch.model.PackageDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packageDetails())
        .map(value => zio.aws.opensearch.model.PackageDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.UpdatePackageResponse
  ): zio.aws.opensearch.model.UpdatePackageResponse.ReadOnly = new Wrapper(impl)
}
