package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.{VersionString, DomainName}
import scala.jdk.CollectionConverters.*
final case class UpgradeDomainResponse(
    upgradeId: Optional[String] = Optional.Absent,
    domainName: Optional[DomainName] = Optional.Absent,
    targetVersion: Optional[VersionString] = Optional.Absent,
    performCheckOnly: Optional[Boolean] = Optional.Absent,
    advancedOptions: Optional[Map[String, String]] = Optional.Absent,
    changeProgressDetails: Optional[
      zio.aws.opensearch.model.ChangeProgressDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.UpgradeDomainResponse = {
    import UpgradeDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.UpgradeDomainResponse
      .builder()
      .optionallyWith(upgradeId.map(value => value: java.lang.String))(
        _.upgradeId
      )
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(
        targetVersion.map(value =>
          VersionString.unwrap(value): java.lang.String
        )
      )(_.targetVersion)
      .optionallyWith(performCheckOnly.map(value => value: java.lang.Boolean))(
        _.performCheckOnly
      )
      .optionallyWith(
        advancedOptions.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.advancedOptions)
      .optionallyWith(
        changeProgressDetails.map(value => value.buildAwsValue())
      )(_.changeProgressDetails)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.UpgradeDomainResponse.ReadOnly =
    zio.aws.opensearch.model.UpgradeDomainResponse.wrap(buildAwsValue())
}
object UpgradeDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.UpgradeDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.UpgradeDomainResponse =
      zio.aws.opensearch.model.UpgradeDomainResponse(
        upgradeId.map(value => value),
        domainName.map(value => value),
        targetVersion.map(value => value),
        performCheckOnly.map(value => value),
        advancedOptions.map(value => value),
        changeProgressDetails.map(value => value.asEditable)
      )
    def upgradeId: Optional[String]
    def domainName: Optional[DomainName]
    def targetVersion: Optional[VersionString]
    def performCheckOnly: Optional[Boolean]
    def advancedOptions: Optional[Map[String, String]]
    def changeProgressDetails
        : Optional[zio.aws.opensearch.model.ChangeProgressDetails.ReadOnly]
    def getUpgradeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("upgradeId", upgradeId)
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getTargetVersion: ZIO[Any, AwsError, VersionString] =
      AwsError.unwrapOptionField("targetVersion", targetVersion)
    def getPerformCheckOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("performCheckOnly", performCheckOnly)
    def getAdvancedOptions: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("advancedOptions", advancedOptions)
    def getChangeProgressDetails: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.ChangeProgressDetails.ReadOnly
    ] =
      AwsError.unwrapOptionField("changeProgressDetails", changeProgressDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.UpgradeDomainResponse
  ) extends zio.aws.opensearch.model.UpgradeDomainResponse.ReadOnly {
    override val upgradeId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.upgradeId())
      .map(value => value: String)
    override val domainName: Optional[DomainName] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => zio.aws.opensearch.model.primitives.DomainName(value))
    override val targetVersion: Optional[VersionString] = zio.aws.core.internal
      .optionalFromNullable(impl.targetVersion())
      .map(value => zio.aws.opensearch.model.primitives.VersionString(value))
    override val performCheckOnly: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.performCheckOnly())
      .map(value => value: Boolean)
    override val advancedOptions: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.advancedOptions())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val changeProgressDetails
        : Optional[zio.aws.opensearch.model.ChangeProgressDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.changeProgressDetails())
        .map(value =>
          zio.aws.opensearch.model.ChangeProgressDetails.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.UpgradeDomainResponse
  ): zio.aws.opensearch.model.UpgradeDomainResponse.ReadOnly = new Wrapper(impl)
}
