package zio.aws.opensearch.model
import zio.aws.opensearch.model.primitives.{StartTimestamp, UpgradeName}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class UpgradeHistory(
    upgradeName: Optional[UpgradeName] = Optional.Absent,
    startTimestamp: Optional[StartTimestamp] = Optional.Absent,
    upgradeStatus: Optional[zio.aws.opensearch.model.UpgradeStatus] =
      Optional.Absent,
    stepsList: Optional[Iterable[zio.aws.opensearch.model.UpgradeStepItem]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.UpgradeHistory = {
    import UpgradeHistory.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.UpgradeHistory
      .builder()
      .optionallyWith(
        upgradeName.map(value => UpgradeName.unwrap(value): java.lang.String)
      )(_.upgradeName)
      .optionallyWith(
        startTimestamp.map(value => StartTimestamp.unwrap(value): Instant)
      )(_.startTimestamp)
      .optionallyWith(upgradeStatus.map(value => value.unwrap))(_.upgradeStatus)
      .optionallyWith(
        stepsList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.stepsList)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.UpgradeHistory.ReadOnly =
    zio.aws.opensearch.model.UpgradeHistory.wrap(buildAwsValue())
}
object UpgradeHistory {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.UpgradeHistory
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.UpgradeHistory =
      zio.aws.opensearch.model.UpgradeHistory(
        upgradeName.map(value => value),
        startTimestamp.map(value => value),
        upgradeStatus.map(value => value),
        stepsList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def upgradeName: Optional[UpgradeName]
    def startTimestamp: Optional[StartTimestamp]
    def upgradeStatus: Optional[zio.aws.opensearch.model.UpgradeStatus]
    def stepsList
        : Optional[List[zio.aws.opensearch.model.UpgradeStepItem.ReadOnly]]
    def getUpgradeName: ZIO[Any, AwsError, UpgradeName] =
      AwsError.unwrapOptionField("upgradeName", upgradeName)
    def getStartTimestamp: ZIO[Any, AwsError, StartTimestamp] =
      AwsError.unwrapOptionField("startTimestamp", startTimestamp)
    def getUpgradeStatus
        : ZIO[Any, AwsError, zio.aws.opensearch.model.UpgradeStatus] =
      AwsError.unwrapOptionField("upgradeStatus", upgradeStatus)
    def getStepsList: ZIO[Any, AwsError, List[
      zio.aws.opensearch.model.UpgradeStepItem.ReadOnly
    ]] = AwsError.unwrapOptionField("stepsList", stepsList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.UpgradeHistory
  ) extends zio.aws.opensearch.model.UpgradeHistory.ReadOnly {
    override val upgradeName: Optional[UpgradeName] = zio.aws.core.internal
      .optionalFromNullable(impl.upgradeName())
      .map(value => zio.aws.opensearch.model.primitives.UpgradeName(value))
    override val startTimestamp: Optional[StartTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startTimestamp())
        .map(value => zio.aws.opensearch.model.primitives.StartTimestamp(value))
    override val upgradeStatus
        : Optional[zio.aws.opensearch.model.UpgradeStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.upgradeStatus())
        .map(value => zio.aws.opensearch.model.UpgradeStatus.wrap(value))
    override val stepsList
        : Optional[List[zio.aws.opensearch.model.UpgradeStepItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stepsList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opensearch.model.UpgradeStepItem.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.UpgradeHistory
  ): zio.aws.opensearch.model.UpgradeHistory.ReadOnly = new Wrapper(impl)
}
