package zio.aws.opensearch.model
import scala.jdk.CollectionConverters.*
sealed trait UpgradeStatus {
  def unwrap: software.amazon.awssdk.services.opensearch.model.UpgradeStatus
}
object UpgradeStatus {
  def wrap(
      value: software.amazon.awssdk.services.opensearch.model.UpgradeStatus
  ): zio.aws.opensearch.model.UpgradeStatus = value match {
    case software.amazon.awssdk.services.opensearch.model.UpgradeStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearch.model.UpgradeStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.opensearch.model.UpgradeStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.opensearch.model.UpgradeStatus.SUCCEEDED_WITH_ISSUES =>
      val r = SUCCEEDED_WITH_ISSUES
      r
    case software.amazon.awssdk.services.opensearch.model.UpgradeStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.opensearch.model.UpgradeStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.UpgradeStatus =
      software.amazon.awssdk.services.opensearch.model.UpgradeStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_PROGRESS extends zio.aws.opensearch.model.UpgradeStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.UpgradeStatus =
      software.amazon.awssdk.services.opensearch.model.UpgradeStatus.IN_PROGRESS
  }
  case object SUCCEEDED extends zio.aws.opensearch.model.UpgradeStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.UpgradeStatus =
      software.amazon.awssdk.services.opensearch.model.UpgradeStatus.SUCCEEDED
  }
  case object SUCCEEDED_WITH_ISSUES
      extends zio.aws.opensearch.model.UpgradeStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.UpgradeStatus =
      software.amazon.awssdk.services.opensearch.model.UpgradeStatus.SUCCEEDED_WITH_ISSUES
  }
  case object FAILED extends zio.aws.opensearch.model.UpgradeStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.UpgradeStatus =
      software.amazon.awssdk.services.opensearch.model.UpgradeStatus.FAILED
  }
}
