package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.Issue
import scala.jdk.CollectionConverters.*
final case class UpgradeStepItem(
    upgradeStep: Optional[zio.aws.opensearch.model.UpgradeStep] =
      Optional.Absent,
    upgradeStepStatus: Optional[zio.aws.opensearch.model.UpgradeStatus] =
      Optional.Absent,
    issues: Optional[Iterable[Issue]] = Optional.Absent,
    progressPercent: Optional[Double] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.UpgradeStepItem = {
    import UpgradeStepItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.UpgradeStepItem
      .builder()
      .optionallyWith(upgradeStep.map(value => value.unwrap))(_.upgradeStep)
      .optionallyWith(upgradeStepStatus.map(value => value.unwrap))(
        _.upgradeStepStatus
      )
      .optionallyWith(
        issues.map(value =>
          value.map { item =>
            Issue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.issues)
      .optionallyWith(progressPercent.map(value => value: java.lang.Double))(
        _.progressPercent
      )
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.UpgradeStepItem.ReadOnly =
    zio.aws.opensearch.model.UpgradeStepItem.wrap(buildAwsValue())
}
object UpgradeStepItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.UpgradeStepItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.UpgradeStepItem =
      zio.aws.opensearch.model.UpgradeStepItem(
        upgradeStep.map(value => value),
        upgradeStepStatus.map(value => value),
        issues.map(value => value),
        progressPercent.map(value => value)
      )
    def upgradeStep: Optional[zio.aws.opensearch.model.UpgradeStep]
    def upgradeStepStatus: Optional[zio.aws.opensearch.model.UpgradeStatus]
    def issues: Optional[List[Issue]]
    def progressPercent: Optional[Double]
    def getUpgradeStep
        : ZIO[Any, AwsError, zio.aws.opensearch.model.UpgradeStep] =
      AwsError.unwrapOptionField("upgradeStep", upgradeStep)
    def getUpgradeStepStatus
        : ZIO[Any, AwsError, zio.aws.opensearch.model.UpgradeStatus] =
      AwsError.unwrapOptionField("upgradeStepStatus", upgradeStepStatus)
    def getIssues: ZIO[Any, AwsError, List[Issue]] =
      AwsError.unwrapOptionField("issues", issues)
    def getProgressPercent: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("progressPercent", progressPercent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.UpgradeStepItem
  ) extends zio.aws.opensearch.model.UpgradeStepItem.ReadOnly {
    override val upgradeStep: Optional[zio.aws.opensearch.model.UpgradeStep] =
      zio.aws.core.internal
        .optionalFromNullable(impl.upgradeStep())
        .map(value => zio.aws.opensearch.model.UpgradeStep.wrap(value))
    override val upgradeStepStatus
        : Optional[zio.aws.opensearch.model.UpgradeStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.upgradeStepStatus())
        .map(value => zio.aws.opensearch.model.UpgradeStatus.wrap(value))
    override val issues: Optional[List[Issue]] = zio.aws.core.internal
      .optionalFromNullable(impl.issues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearch.model.primitives.Issue(item)
        }.toList
      )
    override val progressPercent: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.progressPercent())
      .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.UpgradeStepItem
  ): zio.aws.opensearch.model.UpgradeStepItem.ReadOnly = new Wrapper(impl)
}
