package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VPCDerivedInfo(
    vpcId: Optional[String] = Optional.Absent,
    subnetIds: Optional[Iterable[String]] = Optional.Absent,
    availabilityZones: Optional[Iterable[String]] = Optional.Absent,
    securityGroupIds: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.VPCDerivedInfo = {
    import VPCDerivedInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.VPCDerivedInfo
      .builder()
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.VPCDerivedInfo.ReadOnly =
    zio.aws.opensearch.model.VPCDerivedInfo.wrap(buildAwsValue())
}
object VPCDerivedInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.VPCDerivedInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.VPCDerivedInfo =
      zio.aws.opensearch.model.VPCDerivedInfo(
        vpcId.map(value => value),
        subnetIds.map(value => value),
        availabilityZones.map(value => value),
        securityGroupIds.map(value => value)
      )
    def vpcId: Optional[String]
    def subnetIds: Optional[List[String]]
    def availabilityZones: Optional[List[String]]
    def securityGroupIds: Optional[List[String]]
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSubnetIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.VPCDerivedInfo
  ) extends zio.aws.opensearch.model.VPCDerivedInfo.ReadOnly {
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val subnetIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val availabilityZones: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZones())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val securityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.VPCDerivedInfo
  ): zio.aws.opensearch.model.VPCDerivedInfo.ReadOnly = new Wrapper(impl)
}
