package zio.aws.opensearch.model
import zio.aws.opensearch.model.primitives.IntegerClass
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ZoneAwarenessConfig(
    availabilityZoneCount: Optional[IntegerClass] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.ZoneAwarenessConfig = {
    import ZoneAwarenessConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.ZoneAwarenessConfig
      .builder()
      .optionallyWith(
        availabilityZoneCount.map(value => IntegerClass.unwrap(value): Integer)
      )(_.availabilityZoneCount)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.ZoneAwarenessConfig.ReadOnly =
    zio.aws.opensearch.model.ZoneAwarenessConfig.wrap(buildAwsValue())
}
object ZoneAwarenessConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.ZoneAwarenessConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.ZoneAwarenessConfig =
      zio.aws.opensearch.model
        .ZoneAwarenessConfig(availabilityZoneCount.map(value => value))
    def availabilityZoneCount: Optional[IntegerClass]
    def getAvailabilityZoneCount: ZIO[Any, AwsError, IntegerClass] =
      AwsError.unwrapOptionField("availabilityZoneCount", availabilityZoneCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.ZoneAwarenessConfig
  ) extends zio.aws.opensearch.model.ZoneAwarenessConfig.ReadOnly {
    override val availabilityZoneCount: Optional[IntegerClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZoneCount())
        .map(value => zio.aws.opensearch.model.primitives.IntegerClass(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.ZoneAwarenessConfig
  ): zio.aws.opensearch.model.ZoneAwarenessConfig.ReadOnly = new Wrapper(impl)
}
