package zio.aws.opensearch
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.opensearch.model.primitives.{
  VersionString,
  DescribePackagesFilterValue,
  Issue,
  InstanceRole,
  DomainName,
  ServiceUrl,
  LimitValue,
  NonEmptyString
}
import zio.aws.opensearch.model.primitives.ReferencePath.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object ARN extends Subtype[String]
    type ARN = zio.aws.opensearch.model.primitives.ARN.Type
    object AutoTuneDate extends Subtype[Instant]
    type AutoTuneDate = zio.aws.opensearch.model.primitives.AutoTuneDate.Type
    object BackendRole extends Subtype[String]
    type BackendRole = zio.aws.opensearch.model.primitives.BackendRole.Type
    object ChangeProgressStageName extends Subtype[String]
    type ChangeProgressStageName =
      zio.aws.opensearch.model.primitives.ChangeProgressStageName.Type
    object ChangeProgressStageStatus extends Subtype[String]
    type ChangeProgressStageStatus =
      zio.aws.opensearch.model.primitives.ChangeProgressStageStatus.Type
    object CloudWatchLogsLogGroupArn extends Subtype[String]
    type CloudWatchLogsLogGroupArn =
      zio.aws.opensearch.model.primitives.CloudWatchLogsLogGroupArn.Type
    object CommitMessage extends Subtype[String]
    type CommitMessage = zio.aws.opensearch.model.primitives.CommitMessage.Type
    object ConnectionAlias extends Subtype[String]
    type ConnectionAlias =
      zio.aws.opensearch.model.primitives.ConnectionAlias.Type
    object ConnectionId extends Subtype[String]
    type ConnectionId = zio.aws.opensearch.model.primitives.ConnectionId.Type
    object ConnectionStatusMessage extends Subtype[String]
    type ConnectionStatusMessage =
      zio.aws.opensearch.model.primitives.ConnectionStatusMessage.Type
    object CreatedAt extends Subtype[Instant]
    type CreatedAt = zio.aws.opensearch.model.primitives.CreatedAt.Type
    object DeploymentCloseDateTimeStamp extends Subtype[Instant]
    type DeploymentCloseDateTimeStamp =
      zio.aws.opensearch.model.primitives.DeploymentCloseDateTimeStamp.Type
    object DeploymentType extends Subtype[String]
    type DeploymentType =
      zio.aws.opensearch.model.primitives.DeploymentType.Type
    object DescribePackagesFilterValue extends Subtype[String]
    type DescribePackagesFilterValue =
      zio.aws.opensearch.model.primitives.DescribePackagesFilterValue.Type
    object Description extends Subtype[String]
    type Description = zio.aws.opensearch.model.primitives.Description.Type
    object DisableTimestamp extends Subtype[Instant]
    type DisableTimestamp =
      zio.aws.opensearch.model.primitives.DisableTimestamp.Type
    object DomainId extends Subtype[String]
    type DomainId = zio.aws.opensearch.model.primitives.DomainId.Type
    object DomainName extends Subtype[String]
    type DomainName = zio.aws.opensearch.model.primitives.DomainName.Type
    object DomainNameFqdn extends Subtype[String]
    type DomainNameFqdn =
      zio.aws.opensearch.model.primitives.DomainNameFqdn.Type
    object DryRun extends Subtype[Boolean]
    type DryRun = zio.aws.opensearch.model.primitives.DryRun.Type
    object DurationValue extends Subtype[Long]
    type DurationValue = zio.aws.opensearch.model.primitives.DurationValue.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage = zio.aws.opensearch.model.primitives.ErrorMessage.Type
    object ErrorType extends Subtype[String]
    type ErrorType = zio.aws.opensearch.model.primitives.ErrorType.Type
    object GUID extends Subtype[String]
    type GUID = zio.aws.opensearch.model.primitives.GUID.Type
    object IdentityPoolId extends Subtype[String]
    type IdentityPoolId =
      zio.aws.opensearch.model.primitives.IdentityPoolId.Type
    object InstanceCount extends Subtype[Int]
    type InstanceCount = zio.aws.opensearch.model.primitives.InstanceCount.Type
    object InstanceRole extends Subtype[String]
    type InstanceRole = zio.aws.opensearch.model.primitives.InstanceRole.Type
    type Integer = Int
    object IntegerClass extends Subtype[Int]
    type IntegerClass = zio.aws.opensearch.model.primitives.IntegerClass.Type
    object Issue extends Subtype[String]
    type Issue = zio.aws.opensearch.model.primitives.Issue.Type
    object KmsKeyId extends Subtype[String]
    type KmsKeyId = zio.aws.opensearch.model.primitives.KmsKeyId.Type
    object LastUpdated extends Subtype[Instant]
    type LastUpdated = zio.aws.opensearch.model.primitives.LastUpdated.Type
    object LimitName extends Subtype[String]
    type LimitName = zio.aws.opensearch.model.primitives.LimitName.Type
    object LimitValue extends Subtype[String]
    type LimitValue = zio.aws.opensearch.model.primitives.LimitValue.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.opensearch.model.primitives.MaxResults.Type
    object MaximumInstanceCount extends Subtype[Int]
    type MaximumInstanceCount =
      zio.aws.opensearch.model.primitives.MaximumInstanceCount.Type
    object Message extends Subtype[String]
    type Message = zio.aws.opensearch.model.primitives.Message.Type
    object MinimumInstanceCount extends Subtype[Int]
    type MinimumInstanceCount =
      zio.aws.opensearch.model.primitives.MinimumInstanceCount.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.opensearch.model.primitives.NextToken.Type
    object NonEmptyString extends Subtype[String]
    type NonEmptyString =
      zio.aws.opensearch.model.primitives.NonEmptyString.Type
    object OwnerId extends Subtype[String]
    type OwnerId = zio.aws.opensearch.model.primitives.OwnerId.Type
    object PackageDescription extends Subtype[String]
    type PackageDescription =
      zio.aws.opensearch.model.primitives.PackageDescription.Type
    object PackageID extends Subtype[String]
    type PackageID = zio.aws.opensearch.model.primitives.PackageID.Type
    object PackageName extends Subtype[String]
    type PackageName = zio.aws.opensearch.model.primitives.PackageName.Type
    object PackageVersion extends Subtype[String]
    type PackageVersion =
      zio.aws.opensearch.model.primitives.PackageVersion.Type
    object Password extends Subtype[String]
    type Password = zio.aws.opensearch.model.primitives.Password.Type
    object PolicyDocument extends Subtype[String]
    type PolicyDocument =
      zio.aws.opensearch.model.primitives.PolicyDocument.Type
    object ReferencePath extends Subtype[String]
    type ReferencePath = zio.aws.opensearch.model.primitives.ReferencePath.Type
    object Region extends Subtype[String]
    type Region = zio.aws.opensearch.model.primitives.Region.Type
    object ReservationToken extends Subtype[String]
    type ReservationToken =
      zio.aws.opensearch.model.primitives.ReservationToken.Type
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.opensearch.model.primitives.RoleArn.Type
    object S3BucketName extends Subtype[String]
    type S3BucketName = zio.aws.opensearch.model.primitives.S3BucketName.Type
    object S3Key extends Subtype[String]
    type S3Key = zio.aws.opensearch.model.primitives.S3Key.Type
    object SAMLEntityId extends Subtype[String]
    type SAMLEntityId = zio.aws.opensearch.model.primitives.SAMLEntityId.Type
    object SAMLMetadata extends Subtype[String]
    type SAMLMetadata = zio.aws.opensearch.model.primitives.SAMLMetadata.Type
    object ScheduledAutoTuneDescription extends Subtype[String]
    type ScheduledAutoTuneDescription =
      zio.aws.opensearch.model.primitives.ScheduledAutoTuneDescription.Type
    object ServiceUrl extends Subtype[String]
    type ServiceUrl = zio.aws.opensearch.model.primitives.ServiceUrl.Type
    object StartAt extends Subtype[Instant]
    type StartAt = zio.aws.opensearch.model.primitives.StartAt.Type
    object StartTimestamp extends Subtype[Instant]
    type StartTimestamp =
      zio.aws.opensearch.model.primitives.StartTimestamp.Type
    object StorageSubTypeName extends Subtype[String]
    type StorageSubTypeName =
      zio.aws.opensearch.model.primitives.StorageSubTypeName.Type
    object StorageTypeName extends Subtype[String]
    type StorageTypeName =
      zio.aws.opensearch.model.primitives.StorageTypeName.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.opensearch.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.opensearch.model.primitives.TagValue.Type
    object TotalNumberOfStages extends Subtype[Int]
    type TotalNumberOfStages =
      zio.aws.opensearch.model.primitives.TotalNumberOfStages.Type
    object UIntValue extends Subtype[Int]
    type UIntValue = zio.aws.opensearch.model.primitives.UIntValue.Type
    object UpdateTimestamp extends Subtype[Instant]
    type UpdateTimestamp =
      zio.aws.opensearch.model.primitives.UpdateTimestamp.Type
    object UpgradeName extends Subtype[String]
    type UpgradeName = zio.aws.opensearch.model.primitives.UpgradeName.Type
    object UserPoolId extends Subtype[String]
    type UserPoolId = zio.aws.opensearch.model.primitives.UserPoolId.Type
    object Username extends Subtype[String]
    type Username = zio.aws.opensearch.model.primitives.Username.Type
    object VersionString extends Subtype[String]
    type VersionString = zio.aws.opensearch.model.primitives.VersionString.Type
  }
  type AdditionalLimitList = List[zio.aws.opensearch.model.AdditionalLimit]
  type AdvancedOptions = Map[String, String]
  type AutoTuneList = List[zio.aws.opensearch.model.AutoTune]
  type AutoTuneMaintenanceScheduleList =
    List[zio.aws.opensearch.model.AutoTuneMaintenanceSchedule]
  type ChangeProgressStageList =
    List[zio.aws.opensearch.model.ChangeProgressStage]
  type CompatibleVersionsList =
    List[zio.aws.opensearch.model.CompatibleVersionsMap]
  type DescribePackagesFilterList =
    List[zio.aws.opensearch.model.DescribePackagesFilter]
  type DescribePackagesFilterValues = List[DescribePackagesFilterValue]
  type DomainInfoList = List[zio.aws.opensearch.model.DomainInfo]
  type DomainNameList = List[DomainName]
  type DomainPackageDetailsList =
    List[zio.aws.opensearch.model.DomainPackageDetails]
  type DomainStatusList = List[zio.aws.opensearch.model.DomainStatus]
  type EndpointsMap = Map[String, ServiceUrl]
  type FilterList = List[zio.aws.opensearch.model.Filter]
  type InboundConnections = List[zio.aws.opensearch.model.InboundConnection]
  type InstanceRoleList = List[InstanceRole]
  type InstanceTypeDetailsList =
    List[zio.aws.opensearch.model.InstanceTypeDetails]
  type Issues = List[Issue]
  type LimitValueList = List[LimitValue]
  type LimitsByRole = Map[InstanceRole, zio.aws.opensearch.model.Limits]
  type LogPublishingOptions = Map[
    zio.aws.opensearch.model.LogType,
    zio.aws.opensearch.model.LogPublishingOption
  ]
  type OutboundConnections = List[zio.aws.opensearch.model.OutboundConnection]
  type PackageDetailsList = List[zio.aws.opensearch.model.PackageDetails]
  type PackageVersionHistoryList =
    List[zio.aws.opensearch.model.PackageVersionHistory]
  type RecurringChargeList = List[zio.aws.opensearch.model.RecurringCharge]
  type ReservedInstanceList = List[zio.aws.opensearch.model.ReservedInstance]
  type ReservedInstanceOfferingList =
    List[zio.aws.opensearch.model.ReservedInstanceOffering]
  type StorageTypeLimitList = List[zio.aws.opensearch.model.StorageTypeLimit]
  type StorageTypeList = List[zio.aws.opensearch.model.StorageType]
  type StringList = List[String]
  type TagList = List[zio.aws.opensearch.model.Tag]
  type UpgradeHistoryList = List[zio.aws.opensearch.model.UpgradeHistory]
  type UpgradeStepsList = List[zio.aws.opensearch.model.UpgradeStepItem]
  type ValueStringList = List[NonEmptyString]
  type VersionList = List[VersionString]
}
