package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.opsworkscm.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AccountAttribute(
    name: Optional[String] = Optional.Absent,
    maximum: Optional[Integer] = Optional.Absent,
    used: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.AccountAttribute = {
    import AccountAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.AccountAttribute
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(maximum.map(value => value: java.lang.Integer))(_.maximum)
      .optionallyWith(used.map(value => value: java.lang.Integer))(_.used)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.AccountAttribute.ReadOnly =
    zio.aws.opsworkscm.model.AccountAttribute.wrap(buildAwsValue())
}
object AccountAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.AccountAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.AccountAttribute =
      zio.aws.opsworkscm.model.AccountAttribute(
        name.map(value => value),
        maximum.map(value => value),
        used.map(value => value)
      )
    def name: Optional[String]
    def maximum: Optional[Integer]
    def used: Optional[Integer]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getMaximum: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maximum", maximum)
    def getUsed: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("used", used)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.AccountAttribute
  ) extends zio.aws.opsworkscm.model.AccountAttribute.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val maximum: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maximum())
      .map(value => value: Integer)
    override val used: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.used())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.AccountAttribute
  ): zio.aws.opsworkscm.model.AccountAttribute.ReadOnly = new Wrapper(impl)
}
