package zio.aws.opsworkscm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.opsworkscm.model.primitives.{
  TimeWindowDefinition,
  Timestamp,
  BackupId,
  Integer,
  ServerName
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Backup(
    backupArn: Optional[String] = Optional.Absent,
    backupId: Optional[BackupId] = Optional.Absent,
    backupType: Optional[zio.aws.opsworkscm.model.BackupType] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    engine: Optional[String] = Optional.Absent,
    engineModel: Optional[String] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    instanceProfileArn: Optional[String] = Optional.Absent,
    instanceType: Optional[String] = Optional.Absent,
    keyPair: Optional[String] = Optional.Absent,
    preferredBackupWindow: Optional[TimeWindowDefinition] = Optional.Absent,
    preferredMaintenanceWindow: Optional[TimeWindowDefinition] =
      Optional.Absent,
    s3DataSize: Optional[Integer] = Optional.Absent,
    s3DataUrl: Optional[String] = Optional.Absent,
    s3LogUrl: Optional[String] = Optional.Absent,
    securityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    serverName: Optional[ServerName] = Optional.Absent,
    serviceRoleArn: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.opsworkscm.model.BackupStatus] = Optional.Absent,
    statusDescription: Optional[String] = Optional.Absent,
    subnetIds: Optional[Iterable[String]] = Optional.Absent,
    toolsVersion: Optional[String] = Optional.Absent,
    userArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.Backup = {
    import Backup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.Backup
      .builder()
      .optionallyWith(backupArn.map(value => value: java.lang.String))(
        _.backupArn
      )
      .optionallyWith(
        backupId.map(value => BackupId.unwrap(value): java.lang.String)
      )(_.backupId)
      .optionallyWith(backupType.map(value => value.unwrap))(_.backupType)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineModel.map(value => value: java.lang.String))(
        _.engineModel
      )
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(instanceProfileArn.map(value => value: java.lang.String))(
        _.instanceProfileArn
      )
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(keyPair.map(value => value: java.lang.String))(_.keyPair)
      .optionallyWith(
        preferredBackupWindow.map(value =>
          TimeWindowDefinition.unwrap(value): java.lang.String
        )
      )(_.preferredBackupWindow)
      .optionallyWith(
        preferredMaintenanceWindow.map(value =>
          TimeWindowDefinition.unwrap(value): java.lang.String
        )
      )(_.preferredMaintenanceWindow)
      .optionallyWith(s3DataSize.map(value => value: java.lang.Integer))(
        _.s3DataSize
      )
      .optionallyWith(s3DataUrl.map(value => value: java.lang.String))(
        _.s3DataUrl
      )
      .optionallyWith(s3LogUrl.map(value => value: java.lang.String))(
        _.s3LogUrl
      )
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        serverName.map(value => ServerName.unwrap(value): java.lang.String)
      )(_.serverName)
      .optionallyWith(serviceRoleArn.map(value => value: java.lang.String))(
        _.serviceRoleArn
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusDescription.map(value => value: java.lang.String))(
        _.statusDescription
      )
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(toolsVersion.map(value => value: java.lang.String))(
        _.toolsVersion
      )
      .optionallyWith(userArn.map(value => value: java.lang.String))(_.userArn)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.Backup.ReadOnly =
    zio.aws.opsworkscm.model.Backup.wrap(buildAwsValue())
}
object Backup {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.opsworkscm.model.Backup] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.Backup =
      zio.aws.opsworkscm.model.Backup(
        backupArn.map(value => value),
        backupId.map(value => value),
        backupType.map(value => value),
        createdAt.map(value => value),
        description.map(value => value),
        engine.map(value => value),
        engineModel.map(value => value),
        engineVersion.map(value => value),
        instanceProfileArn.map(value => value),
        instanceType.map(value => value),
        keyPair.map(value => value),
        preferredBackupWindow.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        s3DataSize.map(value => value),
        s3DataUrl.map(value => value),
        s3LogUrl.map(value => value),
        securityGroupIds.map(value => value),
        serverName.map(value => value),
        serviceRoleArn.map(value => value),
        status.map(value => value),
        statusDescription.map(value => value),
        subnetIds.map(value => value),
        toolsVersion.map(value => value),
        userArn.map(value => value)
      )
    def backupArn: Optional[String]
    def backupId: Optional[BackupId]
    def backupType: Optional[zio.aws.opsworkscm.model.BackupType]
    def createdAt: Optional[Timestamp]
    def description: Optional[String]
    def engine: Optional[String]
    def engineModel: Optional[String]
    def engineVersion: Optional[String]
    def instanceProfileArn: Optional[String]
    def instanceType: Optional[String]
    def keyPair: Optional[String]
    def preferredBackupWindow: Optional[TimeWindowDefinition]
    def preferredMaintenanceWindow: Optional[TimeWindowDefinition]
    def s3DataSize: Optional[Integer]
    def s3DataUrl: Optional[String]
    def s3LogUrl: Optional[String]
    def securityGroupIds: Optional[List[String]]
    def serverName: Optional[ServerName]
    def serviceRoleArn: Optional[String]
    def status: Optional[zio.aws.opsworkscm.model.BackupStatus]
    def statusDescription: Optional[String]
    def subnetIds: Optional[List[String]]
    def toolsVersion: Optional[String]
    def userArn: Optional[String]
    def getBackupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("backupArn", backupArn)
    def getBackupId: ZIO[Any, AwsError, BackupId] =
      AwsError.unwrapOptionField("backupId", backupId)
    def getBackupType: ZIO[Any, AwsError, zio.aws.opsworkscm.model.BackupType] =
      AwsError.unwrapOptionField("backupType", backupType)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineModel", engineModel)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getInstanceProfileArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceProfileArn", instanceProfileArn)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getKeyPair: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyPair", keyPair)
    def getPreferredBackupWindow: ZIO[Any, AwsError, TimeWindowDefinition] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getPreferredMaintenanceWindow
        : ZIO[Any, AwsError, TimeWindowDefinition] = AwsError.unwrapOptionField(
      "preferredMaintenanceWindow",
      preferredMaintenanceWindow
    )
    def getS3DataSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("s3DataSize", s3DataSize)
    def getS3DataUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3DataUrl", s3DataUrl)
    def getS3LogUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3LogUrl", s3LogUrl)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getServerName: ZIO[Any, AwsError, ServerName] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getServiceRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceRoleArn", serviceRoleArn)
    def getStatus: ZIO[Any, AwsError, zio.aws.opsworkscm.model.BackupStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusDescription", statusDescription)
    def getSubnetIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getToolsVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("toolsVersion", toolsVersion)
    def getUserArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userArn", userArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.Backup
  ) extends zio.aws.opsworkscm.model.Backup.ReadOnly {
    override val backupArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.backupArn())
      .map(value => value: String)
    override val backupId: Optional[BackupId] = zio.aws.core.internal
      .optionalFromNullable(impl.backupId())
      .map(value => zio.aws.opsworkscm.model.primitives.BackupId(value))
    override val backupType: Optional[zio.aws.opsworkscm.model.BackupType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupType())
        .map(value => zio.aws.opsworkscm.model.BackupType.wrap(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.opsworkscm.model.primitives.Timestamp(value))
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val engineModel: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineModel())
      .map(value => value: String)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val instanceProfileArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceProfileArn())
      .map(value => value: String)
    override val instanceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => value: String)
    override val keyPair: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.keyPair())
      .map(value => value: String)
    override val preferredBackupWindow: Optional[TimeWindowDefinition] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredBackupWindow())
        .map(value =>
          zio.aws.opsworkscm.model.primitives.TimeWindowDefinition(value)
        )
    override val preferredMaintenanceWindow: Optional[TimeWindowDefinition] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value =>
          zio.aws.opsworkscm.model.primitives.TimeWindowDefinition(value)
        )
    override val s3DataSize: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.s3DataSize())
      .map(value => value: Integer)
    override val s3DataUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.s3DataUrl())
      .map(value => value: String)
    override val s3LogUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.s3LogUrl())
      .map(value => value: String)
    override val securityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val serverName: Optional[ServerName] = zio.aws.core.internal
      .optionalFromNullable(impl.serverName())
      .map(value => zio.aws.opsworkscm.model.primitives.ServerName(value))
    override val serviceRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceRoleArn())
      .map(value => value: String)
    override val status: Optional[zio.aws.opsworkscm.model.BackupStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.opsworkscm.model.BackupStatus.wrap(value))
    override val statusDescription: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusDescription())
      .map(value => value: String)
    override val subnetIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val toolsVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.toolsVersion())
      .map(value => value: String)
    override val userArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.userArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.Backup
  ): zio.aws.opsworkscm.model.Backup.ReadOnly = new Wrapper(impl)
}
