package zio.aws.opsworkscm.model
import scala.jdk.CollectionConverters._
sealed trait BackupStatus {
  def unwrap: software.amazon.awssdk.services.opsworkscm.model.BackupStatus
}
object BackupStatus {
  def wrap(
      value: software.amazon.awssdk.services.opsworkscm.model.BackupStatus
  ): zio.aws.opsworkscm.model.BackupStatus = value match {
    case software.amazon.awssdk.services.opsworkscm.model.BackupStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opsworkscm.model.BackupStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.opsworkscm.model.BackupStatus.OK =>
      val r = OK
      r
    case software.amazon.awssdk.services.opsworkscm.model.BackupStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.opsworkscm.model.BackupStatus.DELETING =>
      val r = DELETING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.opsworkscm.model.BackupStatus {
    override def unwrap
        : software.amazon.awssdk.services.opsworkscm.model.BackupStatus =
      software.amazon.awssdk.services.opsworkscm.model.BackupStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_PROGRESS extends zio.aws.opsworkscm.model.BackupStatus {
    override def unwrap
        : software.amazon.awssdk.services.opsworkscm.model.BackupStatus =
      software.amazon.awssdk.services.opsworkscm.model.BackupStatus.IN_PROGRESS
  }
  case object OK extends zio.aws.opsworkscm.model.BackupStatus {
    override def unwrap
        : software.amazon.awssdk.services.opsworkscm.model.BackupStatus =
      software.amazon.awssdk.services.opsworkscm.model.BackupStatus.OK
  }
  case object FAILED extends zio.aws.opsworkscm.model.BackupStatus {
    override def unwrap
        : software.amazon.awssdk.services.opsworkscm.model.BackupStatus =
      software.amazon.awssdk.services.opsworkscm.model.BackupStatus.FAILED
  }
  case object DELETING extends zio.aws.opsworkscm.model.BackupStatus {
    override def unwrap
        : software.amazon.awssdk.services.opsworkscm.model.BackupStatus =
      software.amazon.awssdk.services.opsworkscm.model.BackupStatus.DELETING
  }
}
