package zio.aws.opsworkscm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.opsworkscm.model.primitives.{
  TimeWindowDefinition,
  BackupRetentionCountDefinition,
  BackupId,
  ServiceRoleArn,
  CustomPrivateKey,
  ServerName,
  InstanceProfileArn,
  KeyPair,
  CustomDomain,
  CustomCertificate
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateServerRequest(
    associatePublicIpAddress: Optional[Boolean] = Optional.Absent,
    customDomain: Optional[CustomDomain] = Optional.Absent,
    customCertificate: Optional[CustomCertificate] = Optional.Absent,
    customPrivateKey: Optional[CustomPrivateKey] = Optional.Absent,
    disableAutomatedBackup: Optional[Boolean] = Optional.Absent,
    engine: String,
    engineModel: Optional[String] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    engineAttributes: Optional[
      Iterable[zio.aws.opsworkscm.model.EngineAttribute]
    ] = Optional.Absent,
    backupRetentionCount: Optional[BackupRetentionCountDefinition] =
      Optional.Absent,
    serverName: ServerName,
    instanceProfileArn: InstanceProfileArn,
    instanceType: String,
    keyPair: Optional[KeyPair] = Optional.Absent,
    preferredMaintenanceWindow: Optional[TimeWindowDefinition] =
      Optional.Absent,
    preferredBackupWindow: Optional[TimeWindowDefinition] = Optional.Absent,
    securityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    serviceRoleArn: ServiceRoleArn,
    subnetIds: Optional[Iterable[String]] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.opsworkscm.model.Tag]] = Optional.Absent,
    backupId: Optional[BackupId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.CreateServerRequest = {
    import CreateServerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.CreateServerRequest
      .builder()
      .optionallyWith(
        associatePublicIpAddress.map(value => value: java.lang.Boolean)
      )(_.associatePublicIpAddress)
      .optionallyWith(
        customDomain.map(value => CustomDomain.unwrap(value): java.lang.String)
      )(_.customDomain)
      .optionallyWith(
        customCertificate.map(value =>
          CustomCertificate.unwrap(value): java.lang.String
        )
      )(_.customCertificate)
      .optionallyWith(
        customPrivateKey.map(value =>
          CustomPrivateKey.unwrap(value): java.lang.String
        )
      )(_.customPrivateKey)
      .optionallyWith(
        disableAutomatedBackup.map(value => value: java.lang.Boolean)
      )(_.disableAutomatedBackup)
      .engine(engine: java.lang.String)
      .optionallyWith(engineModel.map(value => value: java.lang.String))(
        _.engineModel
      )
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        engineAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.engineAttributes)
      .optionallyWith(
        backupRetentionCount.map(value =>
          BackupRetentionCountDefinition.unwrap(value): Integer
        )
      )(_.backupRetentionCount)
      .serverName(ServerName.unwrap(serverName): java.lang.String)
      .instanceProfileArn(
        InstanceProfileArn.unwrap(instanceProfileArn): java.lang.String
      )
      .instanceType(instanceType: java.lang.String)
      .optionallyWith(
        keyPair.map(value => KeyPair.unwrap(value): java.lang.String)
      )(_.keyPair)
      .optionallyWith(
        preferredMaintenanceWindow.map(value =>
          TimeWindowDefinition.unwrap(value): java.lang.String
        )
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        preferredBackupWindow.map(value =>
          TimeWindowDefinition.unwrap(value): java.lang.String
        )
      )(_.preferredBackupWindow)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .serviceRoleArn(ServiceRoleArn.unwrap(serviceRoleArn): java.lang.String)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        backupId.map(value => BackupId.unwrap(value): java.lang.String)
      )(_.backupId)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.CreateServerRequest.ReadOnly =
    zio.aws.opsworkscm.model.CreateServerRequest.wrap(buildAwsValue())
}
object CreateServerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.CreateServerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.CreateServerRequest =
      zio.aws.opsworkscm.model.CreateServerRequest(
        associatePublicIpAddress.map(value => value),
        customDomain.map(value => value),
        customCertificate.map(value => value),
        customPrivateKey.map(value => value),
        disableAutomatedBackup.map(value => value),
        engine,
        engineModel.map(value => value),
        engineVersion.map(value => value),
        engineAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        backupRetentionCount.map(value => value),
        serverName,
        instanceProfileArn,
        instanceType,
        keyPair.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        preferredBackupWindow.map(value => value),
        securityGroupIds.map(value => value),
        serviceRoleArn,
        subnetIds.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        backupId.map(value => value)
      )
    def associatePublicIpAddress: Optional[Boolean]
    def customDomain: Optional[CustomDomain]
    def customCertificate: Optional[CustomCertificate]
    def customPrivateKey: Optional[CustomPrivateKey]
    def disableAutomatedBackup: Optional[Boolean]
    def engine: String
    def engineModel: Optional[String]
    def engineVersion: Optional[String]
    def engineAttributes
        : Optional[List[zio.aws.opsworkscm.model.EngineAttribute.ReadOnly]]
    def backupRetentionCount: Optional[BackupRetentionCountDefinition]
    def serverName: ServerName
    def instanceProfileArn: InstanceProfileArn
    def instanceType: String
    def keyPair: Optional[KeyPair]
    def preferredMaintenanceWindow: Optional[TimeWindowDefinition]
    def preferredBackupWindow: Optional[TimeWindowDefinition]
    def securityGroupIds: Optional[List[String]]
    def serviceRoleArn: ServiceRoleArn
    def subnetIds: Optional[List[String]]
    def tags: Optional[List[zio.aws.opsworkscm.model.Tag.ReadOnly]]
    def backupId: Optional[BackupId]
    def getAssociatePublicIpAddress: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("associatePublicIpAddress", associatePublicIpAddress)
    def getCustomDomain: ZIO[Any, AwsError, CustomDomain] =
      AwsError.unwrapOptionField("customDomain", customDomain)
    def getCustomCertificate: ZIO[Any, AwsError, CustomCertificate] =
      AwsError.unwrapOptionField("customCertificate", customCertificate)
    def getCustomPrivateKey: ZIO[Any, AwsError, CustomPrivateKey] =
      AwsError.unwrapOptionField("customPrivateKey", customPrivateKey)
    def getDisableAutomatedBackup: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("disableAutomatedBackup", disableAutomatedBackup)
    def getEngine: ZIO[Any, Nothing, String] = ZIO.succeed(engine)
    def getEngineModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineModel", engineModel)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getEngineAttributes: ZIO[Any, AwsError, List[
      zio.aws.opsworkscm.model.EngineAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("engineAttributes", engineAttributes)
    def getBackupRetentionCount
        : ZIO[Any, AwsError, BackupRetentionCountDefinition] =
      AwsError.unwrapOptionField("backupRetentionCount", backupRetentionCount)
    def getServerName: ZIO[Any, Nothing, ServerName] = ZIO.succeed(serverName)
    def getInstanceProfileArn: ZIO[Any, Nothing, InstanceProfileArn] =
      ZIO.succeed(instanceProfileArn)
    def getInstanceType: ZIO[Any, Nothing, String] = ZIO.succeed(instanceType)
    def getKeyPair: ZIO[Any, AwsError, KeyPair] =
      AwsError.unwrapOptionField("keyPair", keyPair)
    def getPreferredMaintenanceWindow
        : ZIO[Any, AwsError, TimeWindowDefinition] = AwsError.unwrapOptionField(
      "preferredMaintenanceWindow",
      preferredMaintenanceWindow
    )
    def getPreferredBackupWindow: ZIO[Any, AwsError, TimeWindowDefinition] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getServiceRoleArn: ZIO[Any, Nothing, ServiceRoleArn] =
      ZIO.succeed(serviceRoleArn)
    def getSubnetIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.opsworkscm.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getBackupId: ZIO[Any, AwsError, BackupId] =
      AwsError.unwrapOptionField("backupId", backupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.CreateServerRequest
  ) extends zio.aws.opsworkscm.model.CreateServerRequest.ReadOnly {
    override val associatePublicIpAddress: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatePublicIpAddress())
        .map(value => value: Boolean)
    override val customDomain: Optional[CustomDomain] = zio.aws.core.internal
      .optionalFromNullable(impl.customDomain())
      .map(value => zio.aws.opsworkscm.model.primitives.CustomDomain(value))
    override val customCertificate: Optional[CustomCertificate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customCertificate())
        .map(value =>
          zio.aws.opsworkscm.model.primitives.CustomCertificate(value)
        )
    override val customPrivateKey: Optional[CustomPrivateKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customPrivateKey())
        .map(value =>
          zio.aws.opsworkscm.model.primitives.CustomPrivateKey(value)
        )
    override val disableAutomatedBackup: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disableAutomatedBackup())
        .map(value => value: Boolean)
    override val engine: String = impl.engine(): String
    override val engineModel: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineModel())
      .map(value => value: String)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val engineAttributes
        : Optional[List[zio.aws.opsworkscm.model.EngineAttribute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engineAttributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opsworkscm.model.EngineAttribute.wrap(item)
          }.toList
        )
    override val backupRetentionCount
        : Optional[BackupRetentionCountDefinition] = zio.aws.core.internal
      .optionalFromNullable(impl.backupRetentionCount())
      .map(value =>
        zio.aws.opsworkscm.model.primitives
          .BackupRetentionCountDefinition(value)
      )
    override val serverName: ServerName =
      zio.aws.opsworkscm.model.primitives.ServerName(impl.serverName())
    override val instanceProfileArn: InstanceProfileArn =
      zio.aws.opsworkscm.model.primitives
        .InstanceProfileArn(impl.instanceProfileArn())
    override val instanceType: String = impl.instanceType(): String
    override val keyPair: Optional[KeyPair] = zio.aws.core.internal
      .optionalFromNullable(impl.keyPair())
      .map(value => zio.aws.opsworkscm.model.primitives.KeyPair(value))
    override val preferredMaintenanceWindow: Optional[TimeWindowDefinition] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value =>
          zio.aws.opsworkscm.model.primitives.TimeWindowDefinition(value)
        )
    override val preferredBackupWindow: Optional[TimeWindowDefinition] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredBackupWindow())
        .map(value =>
          zio.aws.opsworkscm.model.primitives.TimeWindowDefinition(value)
        )
    override val securityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val serviceRoleArn: ServiceRoleArn =
      zio.aws.opsworkscm.model.primitives.ServiceRoleArn(impl.serviceRoleArn())
    override val subnetIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val tags: Optional[List[zio.aws.opsworkscm.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opsworkscm.model.Tag.wrap(item)
          }.toList
        )
    override val backupId: Optional[BackupId] = zio.aws.core.internal
      .optionalFromNullable(impl.backupId())
      .map(value => zio.aws.opsworkscm.model.primitives.BackupId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.CreateServerRequest
  ): zio.aws.opsworkscm.model.CreateServerRequest.ReadOnly = new Wrapper(impl)
}
