package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateServerResponse(
    server: Optional[zio.aws.opsworkscm.model.Server] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.CreateServerResponse = {
    import CreateServerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.CreateServerResponse
      .builder()
      .optionallyWith(server.map(value => value.buildAwsValue()))(_.server)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.CreateServerResponse.ReadOnly =
    zio.aws.opsworkscm.model.CreateServerResponse.wrap(buildAwsValue())
}
object CreateServerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.CreateServerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.CreateServerResponse =
      zio.aws.opsworkscm.model
        .CreateServerResponse(server.map(value => value.asEditable))
    def server: Optional[zio.aws.opsworkscm.model.Server.ReadOnly]
    def getServer
        : ZIO[Any, AwsError, zio.aws.opsworkscm.model.Server.ReadOnly] =
      AwsError.unwrapOptionField("server", server)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.CreateServerResponse
  ) extends zio.aws.opsworkscm.model.CreateServerResponse.ReadOnly {
    override val server: Optional[zio.aws.opsworkscm.model.Server.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.server())
        .map(value => zio.aws.opsworkscm.model.Server.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.CreateServerResponse
  ): zio.aws.opsworkscm.model.CreateServerResponse.ReadOnly = new Wrapper(impl)
}
