package zio.aws.opsworkscm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.opsworkscm.model.primitives.{MaxResults, NextToken, ServerName}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeEventsRequest(
    serverName: ServerName,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.DescribeEventsRequest = {
    import DescribeEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.DescribeEventsRequest
      .builder()
      .serverName(ServerName.unwrap(serverName): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.DescribeEventsRequest.ReadOnly =
    zio.aws.opsworkscm.model.DescribeEventsRequest.wrap(buildAwsValue())
}
object DescribeEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.DescribeEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.DescribeEventsRequest =
      zio.aws.opsworkscm.model.DescribeEventsRequest(
        serverName,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def serverName: ServerName
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getServerName: ZIO[Any, Nothing, ServerName] = ZIO.succeed(serverName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.DescribeEventsRequest
  ) extends zio.aws.opsworkscm.model.DescribeEventsRequest.ReadOnly {
    override val serverName: ServerName =
      zio.aws.opsworkscm.model.primitives.ServerName(impl.serverName())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.opsworkscm.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.opsworkscm.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.DescribeEventsRequest
  ): zio.aws.opsworkscm.model.DescribeEventsRequest.ReadOnly = new Wrapper(impl)
}
