package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeServersResponse(
    servers: Optional[Iterable[zio.aws.opsworkscm.model.Server]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.DescribeServersResponse = {
    import DescribeServersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.DescribeServersResponse
      .builder()
      .optionallyWith(
        servers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.servers)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.DescribeServersResponse.ReadOnly =
    zio.aws.opsworkscm.model.DescribeServersResponse.wrap(buildAwsValue())
}
object DescribeServersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.DescribeServersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.DescribeServersResponse =
      zio.aws.opsworkscm.model.DescribeServersResponse(
        servers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def servers: Optional[List[zio.aws.opsworkscm.model.Server.ReadOnly]]
    def nextToken: Optional[String]
    def getServers
        : ZIO[Any, AwsError, List[zio.aws.opsworkscm.model.Server.ReadOnly]] =
      AwsError.unwrapOptionField("servers", servers)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.DescribeServersResponse
  ) extends zio.aws.opsworkscm.model.DescribeServersResponse.ReadOnly {
    override val servers
        : Optional[List[zio.aws.opsworkscm.model.Server.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.servers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opsworkscm.model.Server.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.DescribeServersResponse
  ): zio.aws.opsworkscm.model.DescribeServersResponse.ReadOnly = new Wrapper(
    impl
  )
}
