package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.opsworkscm.model.primitives.{
  EngineAttributeValue,
  EngineAttributeName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EngineAttribute(
    name: Optional[EngineAttributeName] = Optional.Absent,
    value: Optional[EngineAttributeValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.EngineAttribute = {
    import EngineAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.EngineAttribute
      .builder()
      .optionallyWith(
        name.map(value => EngineAttributeName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        value.map(value => EngineAttributeValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.EngineAttribute.ReadOnly =
    zio.aws.opsworkscm.model.EngineAttribute.wrap(buildAwsValue())
}
object EngineAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.EngineAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.EngineAttribute =
      zio.aws.opsworkscm.model
        .EngineAttribute(name.map(value => value), value.map(value => value))
    def name: Optional[EngineAttributeName]
    def value: Optional[EngineAttributeValue]
    def getName: ZIO[Any, AwsError, EngineAttributeName] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, EngineAttributeValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.EngineAttribute
  ) extends zio.aws.opsworkscm.model.EngineAttribute.ReadOnly {
    override val name: Optional[EngineAttributeName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.opsworkscm.model.primitives.EngineAttributeName(value)
      )
    override val value: Optional[EngineAttributeValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value =>
        zio.aws.opsworkscm.model.primitives.EngineAttributeValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.EngineAttribute
  ): zio.aws.opsworkscm.model.EngineAttribute.ReadOnly = new Wrapper(impl)
}
