package zio.aws.opsworkscm.model
import zio.ZIO
import zio.aws.opsworkscm.model.primitives.{KeyPair, ServerName, BackupId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RestoreServerRequest(
    backupId: BackupId,
    serverName: ServerName,
    instanceType: Optional[String] = Optional.Absent,
    keyPair: Optional[KeyPair] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opsworkscm.model.RestoreServerRequest = {
    import RestoreServerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opsworkscm.model.RestoreServerRequest
      .builder()
      .backupId(BackupId.unwrap(backupId): java.lang.String)
      .serverName(ServerName.unwrap(serverName): java.lang.String)
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(
        keyPair.map(value => KeyPair.unwrap(value): java.lang.String)
      )(_.keyPair)
      .build()
  }
  def asReadOnly: zio.aws.opsworkscm.model.RestoreServerRequest.ReadOnly =
    zio.aws.opsworkscm.model.RestoreServerRequest.wrap(buildAwsValue())
}
object RestoreServerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opsworkscm.model.RestoreServerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opsworkscm.model.RestoreServerRequest =
      zio.aws.opsworkscm.model.RestoreServerRequest(
        backupId,
        serverName,
        instanceType.map(value => value),
        keyPair.map(value => value)
      )
    def backupId: BackupId
    def serverName: ServerName
    def instanceType: Optional[String]
    def keyPair: Optional[KeyPair]
    def getBackupId: ZIO[Any, Nothing, BackupId] = ZIO.succeed(backupId)
    def getServerName: ZIO[Any, Nothing, ServerName] = ZIO.succeed(serverName)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getKeyPair: ZIO[Any, AwsError, KeyPair] =
      AwsError.unwrapOptionField("keyPair", keyPair)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opsworkscm.model.RestoreServerRequest
  ) extends zio.aws.opsworkscm.model.RestoreServerRequest.ReadOnly {
    override val backupId: BackupId =
      zio.aws.opsworkscm.model.primitives.BackupId(impl.backupId())
    override val serverName: ServerName =
      zio.aws.opsworkscm.model.primitives.ServerName(impl.serverName())
    override val instanceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => value: String)
    override val keyPair: Optional[KeyPair] = zio.aws.core.internal
      .optionalFromNullable(impl.keyPair())
      .map(value => zio.aws.opsworkscm.model.primitives.KeyPair(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opsworkscm.model.RestoreServerRequest
  ): zio.aws.opsworkscm.model.RestoreServerRequest.ReadOnly = new Wrapper(impl)
}
