package zio.aws.panorama
import zio.aws.panorama.model.TagResourceResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.panorama.model.{
  ListApplicationInstanceDependenciesRequest,
  CreateJobForDevicesResponse,
  ListApplicationInstancesRequest,
  DeleteDeviceResponse,
  ListDevicesJobsResponse,
  ListPackagesRequest,
  ListNodesResponse,
  DescribeDeviceRequest,
  CreatePackageImportJobRequest,
  RemoveApplicationInstanceRequest,
  UpdateDeviceMetadataResponse,
  ListApplicationInstanceNodeInstancesResponse,
  PackageObject,
  RemoveApplicationInstanceResponse,
  DescribeApplicationInstanceDetailsResponse,
  ListNodesRequest,
  DescribeNodeFromTemplateJobRequest,
  CreatePackageResponse,
  DescribeApplicationInstanceRequest,
  ListApplicationInstanceNodeInstancesRequest,
  ListDevicesResponse,
  ListTagsForResourceRequest,
  NodeFromTemplateJob,
  RegisterPackageVersionRequest,
  DeletePackageRequest,
  CreateApplicationInstanceRequest,
  ListApplicationInstancesResponse,
  DescribeNodeResponse,
  ListTagsForResourceResponse,
  CreateNodeFromTemplateJobRequest,
  UntagResourceResponse,
  CreatePackageRequest,
  DescribePackageRequest,
  ListDevicesJobsRequest,
  PackageListItem,
  PackageImportJob,
  SignalApplicationInstanceNodeInstancesResponse,
  ProvisionDeviceRequest,
  ProvisionDeviceResponse,
  RegisterPackageVersionResponse,
  DescribePackageResponse,
  DescribePackageVersionRequest,
  DescribeDeviceResponse,
  Node,
  ListPackageImportJobsResponse,
  CreateApplicationInstanceResponse,
  DeregisterPackageVersionResponse,
  ListPackageImportJobsRequest,
  DescribeApplicationInstanceResponse,
  Device,
  ListNodeFromTemplateJobsResponse,
  UntagResourceRequest,
  DescribeApplicationInstanceDetailsRequest,
  CreatePackageImportJobResponse,
  DescribePackageImportJobRequest,
  SignalApplicationInstanceNodeInstancesRequest,
  ListApplicationInstanceDependenciesResponse,
  ListDevicesRequest,
  DeregisterPackageVersionRequest,
  DescribeNodeRequest,
  ListNodeFromTemplateJobsRequest,
  TagResourceResponse,
  ApplicationInstance,
  NodeInstance,
  DeletePackageResponse,
  DeviceJob,
  DescribePackageVersionResponse,
  DeleteDeviceRequest,
  DescribePackageImportJobResponse,
  CreateJobForDevicesRequest,
  DescribeDeviceJobResponse,
  ListPackagesResponse,
  TagResourceRequest,
  UpdateDeviceMetadataRequest,
  DescribeNodeFromTemplateJobResponse,
  DescribeDeviceJobRequest,
  CreateNodeFromTemplateJobResponse
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import software.amazon.awssdk.services.panorama.{
  PanoramaAsyncClientBuilder,
  PanoramaAsyncClient
}
import scala.jdk.CollectionConverters._
trait Panorama extends AspectSupport[Panorama] {
  val api: PanoramaAsyncClient
  def provisionDevice(
      request: zio.aws.panorama.model.ProvisionDeviceRequest
  ): IO[AwsError, zio.aws.panorama.model.ProvisionDeviceResponse.ReadOnly]
  def createPackage(
      request: zio.aws.panorama.model.CreatePackageRequest
  ): IO[AwsError, zio.aws.panorama.model.CreatePackageResponse.ReadOnly]
  def describeDevice(
      request: zio.aws.panorama.model.DescribeDeviceRequest
  ): IO[AwsError, zio.aws.panorama.model.DescribeDeviceResponse.ReadOnly]
  def deleteDevice(
      request: zio.aws.panorama.model.DeleteDeviceRequest
  ): IO[AwsError, zio.aws.panorama.model.DeleteDeviceResponse.ReadOnly]
  def describePackageImportJob(
      request: zio.aws.panorama.model.DescribePackageImportJobRequest
  ): IO[
    AwsError,
    zio.aws.panorama.model.DescribePackageImportJobResponse.ReadOnly
  ]
  def listPackageImportJobs(
      request: zio.aws.panorama.model.ListPackageImportJobsRequest
  ): ZStream[Any, AwsError, zio.aws.panorama.model.PackageImportJob.ReadOnly]
  def listPackageImportJobsPaginated(
      request: zio.aws.panorama.model.ListPackageImportJobsRequest
  ): IO[AwsError, zio.aws.panorama.model.ListPackageImportJobsResponse.ReadOnly]
  def signalApplicationInstanceNodeInstances(
      request: zio.aws.panorama.model.SignalApplicationInstanceNodeInstancesRequest
  ): IO[
    AwsError,
    zio.aws.panorama.model.SignalApplicationInstanceNodeInstancesResponse.ReadOnly
  ]
  def listApplicationInstanceNodeInstances(
      request: zio.aws.panorama.model.ListApplicationInstanceNodeInstancesRequest
  ): ZStream[Any, AwsError, zio.aws.panorama.model.NodeInstance.ReadOnly]
  def listApplicationInstanceNodeInstancesPaginated(
      request: zio.aws.panorama.model.ListApplicationInstanceNodeInstancesRequest
  ): IO[
    AwsError,
    zio.aws.panorama.model.ListApplicationInstanceNodeInstancesResponse.ReadOnly
  ]
  def listDevicesJobs(
      request: zio.aws.panorama.model.ListDevicesJobsRequest
  ): ZStream[Any, AwsError, zio.aws.panorama.model.DeviceJob.ReadOnly]
  def listDevicesJobsPaginated(
      request: zio.aws.panorama.model.ListDevicesJobsRequest
  ): IO[AwsError, zio.aws.panorama.model.ListDevicesJobsResponse.ReadOnly]
  def listDevices(
      request: zio.aws.panorama.model.ListDevicesRequest
  ): ZStream[Any, AwsError, zio.aws.panorama.model.Device.ReadOnly]
  def listDevicesPaginated(
      request: zio.aws.panorama.model.ListDevicesRequest
  ): IO[AwsError, zio.aws.panorama.model.ListDevicesResponse.ReadOnly]
  def createNodeFromTemplateJob(
      request: zio.aws.panorama.model.CreateNodeFromTemplateJobRequest
  ): IO[
    AwsError,
    zio.aws.panorama.model.CreateNodeFromTemplateJobResponse.ReadOnly
  ]
  def removeApplicationInstance(
      request: zio.aws.panorama.model.RemoveApplicationInstanceRequest
  ): IO[
    AwsError,
    zio.aws.panorama.model.RemoveApplicationInstanceResponse.ReadOnly
  ]
  def createJobForDevices(
      request: zio.aws.panorama.model.CreateJobForDevicesRequest
  ): IO[AwsError, zio.aws.panorama.model.CreateJobForDevicesResponse.ReadOnly]
  def createPackageImportJob(
      request: zio.aws.panorama.model.CreatePackageImportJobRequest
  ): IO[
    AwsError,
    zio.aws.panorama.model.CreatePackageImportJobResponse.ReadOnly
  ]
  def describeNode(
      request: zio.aws.panorama.model.DescribeNodeRequest
  ): IO[AwsError, zio.aws.panorama.model.DescribeNodeResponse.ReadOnly]
  def describePackage(
      request: zio.aws.panorama.model.DescribePackageRequest
  ): IO[AwsError, zio.aws.panorama.model.DescribePackageResponse.ReadOnly]
  def untagResource(
      request: zio.aws.panorama.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.panorama.model.UntagResourceResponse.ReadOnly]
  def deregisterPackageVersion(
      request: zio.aws.panorama.model.DeregisterPackageVersionRequest
  ): IO[
    AwsError,
    zio.aws.panorama.model.DeregisterPackageVersionResponse.ReadOnly
  ]
  def listApplicationInstances(
      request: zio.aws.panorama.model.ListApplicationInstancesRequest
  ): ZStream[Any, AwsError, zio.aws.panorama.model.ApplicationInstance.ReadOnly]
  def listApplicationInstancesPaginated(
      request: zio.aws.panorama.model.ListApplicationInstancesRequest
  ): IO[
    AwsError,
    zio.aws.panorama.model.ListApplicationInstancesResponse.ReadOnly
  ]
  def describeDeviceJob(
      request: zio.aws.panorama.model.DescribeDeviceJobRequest
  ): IO[AwsError, zio.aws.panorama.model.DescribeDeviceJobResponse.ReadOnly]
  def describePackageVersion(
      request: zio.aws.panorama.model.DescribePackageVersionRequest
  ): IO[
    AwsError,
    zio.aws.panorama.model.DescribePackageVersionResponse.ReadOnly
  ]
  def listTagsForResource(
      request: zio.aws.panorama.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.panorama.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(
      request: zio.aws.panorama.model.TagResourceRequest
  ): IO[AwsError, ReadOnly]
  def deletePackage(
      request: zio.aws.panorama.model.DeletePackageRequest
  ): IO[AwsError, zio.aws.panorama.model.DeletePackageResponse.ReadOnly]
  def listNodeFromTemplateJobs(
      request: zio.aws.panorama.model.ListNodeFromTemplateJobsRequest
  ): ZStream[Any, AwsError, zio.aws.panorama.model.NodeFromTemplateJob.ReadOnly]
  def listNodeFromTemplateJobsPaginated(
      request: zio.aws.panorama.model.ListNodeFromTemplateJobsRequest
  ): IO[
    AwsError,
    zio.aws.panorama.model.ListNodeFromTemplateJobsResponse.ReadOnly
  ]
  def createApplicationInstance(
      request: zio.aws.panorama.model.CreateApplicationInstanceRequest
  ): IO[
    AwsError,
    zio.aws.panorama.model.CreateApplicationInstanceResponse.ReadOnly
  ]
  def listApplicationInstanceDependencies(
      request: zio.aws.panorama.model.ListApplicationInstanceDependenciesRequest
  ): ZStream[Any, AwsError, zio.aws.panorama.model.PackageObject.ReadOnly]
  def listApplicationInstanceDependenciesPaginated(
      request: zio.aws.panorama.model.ListApplicationInstanceDependenciesRequest
  ): IO[
    AwsError,
    zio.aws.panorama.model.ListApplicationInstanceDependenciesResponse.ReadOnly
  ]
  def describeApplicationInstanceDetails(
      request: zio.aws.panorama.model.DescribeApplicationInstanceDetailsRequest
  ): IO[
    AwsError,
    zio.aws.panorama.model.DescribeApplicationInstanceDetailsResponse.ReadOnly
  ]
  def registerPackageVersion(
      request: zio.aws.panorama.model.RegisterPackageVersionRequest
  ): IO[
    AwsError,
    zio.aws.panorama.model.RegisterPackageVersionResponse.ReadOnly
  ]
  def describeApplicationInstance(
      request: zio.aws.panorama.model.DescribeApplicationInstanceRequest
  ): IO[
    AwsError,
    zio.aws.panorama.model.DescribeApplicationInstanceResponse.ReadOnly
  ]
  def updateDeviceMetadata(
      request: zio.aws.panorama.model.UpdateDeviceMetadataRequest
  ): IO[AwsError, zio.aws.panorama.model.UpdateDeviceMetadataResponse.ReadOnly]
  def listNodes(
      request: zio.aws.panorama.model.ListNodesRequest
  ): ZStream[Any, AwsError, zio.aws.panorama.model.Node.ReadOnly]
  def listNodesPaginated(
      request: zio.aws.panorama.model.ListNodesRequest
  ): IO[AwsError, zio.aws.panorama.model.ListNodesResponse.ReadOnly]
  def listPackages(
      request: zio.aws.panorama.model.ListPackagesRequest
  ): ZStream[Any, AwsError, zio.aws.panorama.model.PackageListItem.ReadOnly]
  def listPackagesPaginated(
      request: zio.aws.panorama.model.ListPackagesRequest
  ): IO[AwsError, zio.aws.panorama.model.ListPackagesResponse.ReadOnly]
  def describeNodeFromTemplateJob(
      request: zio.aws.panorama.model.DescribeNodeFromTemplateJobRequest
  ): IO[
    AwsError,
    zio.aws.panorama.model.DescribeNodeFromTemplateJobResponse.ReadOnly
  ]
}
object Panorama {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Panorama] = customized(
    identity
  )
  def customized(
      customization: PanoramaAsyncClientBuilder => PanoramaAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Panorama] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: PanoramaAsyncClientBuilder => PanoramaAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Panorama] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = PanoramaAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[PanoramaAsyncClient, PanoramaAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[PanoramaAsyncClient, PanoramaAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new PanoramaImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class PanoramaImpl[R](
      override val api: PanoramaAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Panorama
      with AwsServiceBase[R] {
    override val serviceName: String = "Panorama"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): PanoramaImpl[R1] = new PanoramaImpl(api, newAspect, r)
    def provisionDevice(
        request: zio.aws.panorama.model.ProvisionDeviceRequest
    ): IO[AwsError, zio.aws.panorama.model.ProvisionDeviceResponse.ReadOnly] =
      asyncRequestResponse[ProvisionDeviceRequest, ProvisionDeviceResponse](
        "provisionDevice",
        api.provisionDevice
      )(request.buildAwsValue())
        .map(zio.aws.panorama.model.ProvisionDeviceResponse.wrap)
        .provideEnvironment(r)
    def createPackage(
        request: zio.aws.panorama.model.CreatePackageRequest
    ): IO[AwsError, zio.aws.panorama.model.CreatePackageResponse.ReadOnly] =
      asyncRequestResponse[CreatePackageRequest, CreatePackageResponse](
        "createPackage",
        api.createPackage
      )(request.buildAwsValue())
        .map(zio.aws.panorama.model.CreatePackageResponse.wrap)
        .provideEnvironment(r)
    def describeDevice(
        request: zio.aws.panorama.model.DescribeDeviceRequest
    ): IO[AwsError, zio.aws.panorama.model.DescribeDeviceResponse.ReadOnly] =
      asyncRequestResponse[DescribeDeviceRequest, DescribeDeviceResponse](
        "describeDevice",
        api.describeDevice
      )(request.buildAwsValue())
        .map(zio.aws.panorama.model.DescribeDeviceResponse.wrap)
        .provideEnvironment(r)
    def deleteDevice(
        request: zio.aws.panorama.model.DeleteDeviceRequest
    ): IO[AwsError, zio.aws.panorama.model.DeleteDeviceResponse.ReadOnly] =
      asyncRequestResponse[DeleteDeviceRequest, DeleteDeviceResponse](
        "deleteDevice",
        api.deleteDevice
      )(request.buildAwsValue())
        .map(zio.aws.panorama.model.DeleteDeviceResponse.wrap)
        .provideEnvironment(r)
    def describePackageImportJob(
        request: zio.aws.panorama.model.DescribePackageImportJobRequest
    ): IO[
      AwsError,
      zio.aws.panorama.model.DescribePackageImportJobResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribePackageImportJobRequest,
      DescribePackageImportJobResponse
    ]("describePackageImportJob", api.describePackageImportJob)(
      request.buildAwsValue()
    ).map(zio.aws.panorama.model.DescribePackageImportJobResponse.wrap)
      .provideEnvironment(r)
    def listPackageImportJobs(
        request: zio.aws.panorama.model.ListPackageImportJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.panorama.model.PackageImportJob.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListPackageImportJobsRequest,
      ListPackageImportJobsResponse,
      PackageImportJob
    ](
      "listPackageImportJobs",
      api.listPackageImportJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.packageImportJobs().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.panorama.model.PackageImportJob.wrap(item))
      .provideEnvironment(r)
    def listPackageImportJobsPaginated(
        request: zio.aws.panorama.model.ListPackageImportJobsRequest
    ): IO[
      AwsError,
      zio.aws.panorama.model.ListPackageImportJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListPackageImportJobsRequest,
      ListPackageImportJobsResponse
    ]("listPackageImportJobs", api.listPackageImportJobs)(
      request.buildAwsValue()
    ).map(zio.aws.panorama.model.ListPackageImportJobsResponse.wrap)
      .provideEnvironment(r)
    def signalApplicationInstanceNodeInstances(
        request: zio.aws.panorama.model.SignalApplicationInstanceNodeInstancesRequest
    ): IO[
      AwsError,
      zio.aws.panorama.model.SignalApplicationInstanceNodeInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      SignalApplicationInstanceNodeInstancesRequest,
      SignalApplicationInstanceNodeInstancesResponse
    ](
      "signalApplicationInstanceNodeInstances",
      api.signalApplicationInstanceNodeInstances
    )(request.buildAwsValue())
      .map(
        zio.aws.panorama.model.SignalApplicationInstanceNodeInstancesResponse.wrap
      )
      .provideEnvironment(r)
    def listApplicationInstanceNodeInstances(
        request: zio.aws.panorama.model.ListApplicationInstanceNodeInstancesRequest
    ): ZStream[Any, AwsError, zio.aws.panorama.model.NodeInstance.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListApplicationInstanceNodeInstancesRequest,
        ListApplicationInstanceNodeInstancesResponse,
        NodeInstance
      ](
        "listApplicationInstanceNodeInstances",
        api.listApplicationInstanceNodeInstances,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.nodeInstances().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.panorama.model.NodeInstance.wrap(item))
        .provideEnvironment(r)
    def listApplicationInstanceNodeInstancesPaginated(
        request: zio.aws.panorama.model.ListApplicationInstanceNodeInstancesRequest
    ): IO[
      AwsError,
      zio.aws.panorama.model.ListApplicationInstanceNodeInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListApplicationInstanceNodeInstancesRequest,
      ListApplicationInstanceNodeInstancesResponse
    ](
      "listApplicationInstanceNodeInstances",
      api.listApplicationInstanceNodeInstances
    )(request.buildAwsValue())
      .map(
        zio.aws.panorama.model.ListApplicationInstanceNodeInstancesResponse.wrap
      )
      .provideEnvironment(r)
    def listDevicesJobs(
        request: zio.aws.panorama.model.ListDevicesJobsRequest
    ): ZStream[Any, AwsError, zio.aws.panorama.model.DeviceJob.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListDevicesJobsRequest,
        ListDevicesJobsResponse,
        DeviceJob
      ](
        "listDevicesJobs",
        api.listDevicesJobs,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.deviceJobs().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.panorama.model.DeviceJob.wrap(item))
        .provideEnvironment(r)
    def listDevicesJobsPaginated(
        request: zio.aws.panorama.model.ListDevicesJobsRequest
    ): IO[AwsError, zio.aws.panorama.model.ListDevicesJobsResponse.ReadOnly] =
      asyncRequestResponse[ListDevicesJobsRequest, ListDevicesJobsResponse](
        "listDevicesJobs",
        api.listDevicesJobs
      )(request.buildAwsValue())
        .map(zio.aws.panorama.model.ListDevicesJobsResponse.wrap)
        .provideEnvironment(r)
    def listDevices(
        request: zio.aws.panorama.model.ListDevicesRequest
    ): ZStream[Any, AwsError, zio.aws.panorama.model.Device.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListDevicesRequest,
        ListDevicesResponse,
        Device
      ](
        "listDevices",
        api.listDevices,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.devices().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.panorama.model.Device.wrap(item))
        .provideEnvironment(r)
    def listDevicesPaginated(
        request: zio.aws.panorama.model.ListDevicesRequest
    ): IO[AwsError, zio.aws.panorama.model.ListDevicesResponse.ReadOnly] =
      asyncRequestResponse[ListDevicesRequest, ListDevicesResponse](
        "listDevices",
        api.listDevices
      )(request.buildAwsValue())
        .map(zio.aws.panorama.model.ListDevicesResponse.wrap)
        .provideEnvironment(r)
    def createNodeFromTemplateJob(
        request: zio.aws.panorama.model.CreateNodeFromTemplateJobRequest
    ): IO[
      AwsError,
      zio.aws.panorama.model.CreateNodeFromTemplateJobResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateNodeFromTemplateJobRequest,
      CreateNodeFromTemplateJobResponse
    ]("createNodeFromTemplateJob", api.createNodeFromTemplateJob)(
      request.buildAwsValue()
    ).map(zio.aws.panorama.model.CreateNodeFromTemplateJobResponse.wrap)
      .provideEnvironment(r)
    def removeApplicationInstance(
        request: zio.aws.panorama.model.RemoveApplicationInstanceRequest
    ): IO[
      AwsError,
      zio.aws.panorama.model.RemoveApplicationInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      RemoveApplicationInstanceRequest,
      RemoveApplicationInstanceResponse
    ]("removeApplicationInstance", api.removeApplicationInstance)(
      request.buildAwsValue()
    ).map(zio.aws.panorama.model.RemoveApplicationInstanceResponse.wrap)
      .provideEnvironment(r)
    def createJobForDevices(
        request: zio.aws.panorama.model.CreateJobForDevicesRequest
    ): IO[
      AwsError,
      zio.aws.panorama.model.CreateJobForDevicesResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateJobForDevicesRequest,
      CreateJobForDevicesResponse
    ]("createJobForDevices", api.createJobForDevices)(request.buildAwsValue())
      .map(zio.aws.panorama.model.CreateJobForDevicesResponse.wrap)
      .provideEnvironment(r)
    def createPackageImportJob(
        request: zio.aws.panorama.model.CreatePackageImportJobRequest
    ): IO[
      AwsError,
      zio.aws.panorama.model.CreatePackageImportJobResponse.ReadOnly
    ] = asyncRequestResponse[
      CreatePackageImportJobRequest,
      CreatePackageImportJobResponse
    ]("createPackageImportJob", api.createPackageImportJob)(
      request.buildAwsValue()
    ).map(zio.aws.panorama.model.CreatePackageImportJobResponse.wrap)
      .provideEnvironment(r)
    def describeNode(
        request: zio.aws.panorama.model.DescribeNodeRequest
    ): IO[AwsError, zio.aws.panorama.model.DescribeNodeResponse.ReadOnly] =
      asyncRequestResponse[DescribeNodeRequest, DescribeNodeResponse](
        "describeNode",
        api.describeNode
      )(request.buildAwsValue())
        .map(zio.aws.panorama.model.DescribeNodeResponse.wrap)
        .provideEnvironment(r)
    def describePackage(
        request: zio.aws.panorama.model.DescribePackageRequest
    ): IO[AwsError, zio.aws.panorama.model.DescribePackageResponse.ReadOnly] =
      asyncRequestResponse[DescribePackageRequest, DescribePackageResponse](
        "describePackage",
        api.describePackage
      )(request.buildAwsValue())
        .map(zio.aws.panorama.model.DescribePackageResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.panorama.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.panorama.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.panorama.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def deregisterPackageVersion(
        request: zio.aws.panorama.model.DeregisterPackageVersionRequest
    ): IO[
      AwsError,
      zio.aws.panorama.model.DeregisterPackageVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      DeregisterPackageVersionRequest,
      DeregisterPackageVersionResponse
    ]("deregisterPackageVersion", api.deregisterPackageVersion)(
      request.buildAwsValue()
    ).map(zio.aws.panorama.model.DeregisterPackageVersionResponse.wrap)
      .provideEnvironment(r)
    def listApplicationInstances(
        request: zio.aws.panorama.model.ListApplicationInstancesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.panorama.model.ApplicationInstance.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListApplicationInstancesRequest,
      ListApplicationInstancesResponse,
      ApplicationInstance
    ](
      "listApplicationInstances",
      api.listApplicationInstances,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.applicationInstances().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.panorama.model.ApplicationInstance.wrap(item))
      .provideEnvironment(r)
    def listApplicationInstancesPaginated(
        request: zio.aws.panorama.model.ListApplicationInstancesRequest
    ): IO[
      AwsError,
      zio.aws.panorama.model.ListApplicationInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListApplicationInstancesRequest,
      ListApplicationInstancesResponse
    ]("listApplicationInstances", api.listApplicationInstances)(
      request.buildAwsValue()
    ).map(zio.aws.panorama.model.ListApplicationInstancesResponse.wrap)
      .provideEnvironment(r)
    def describeDeviceJob(
        request: zio.aws.panorama.model.DescribeDeviceJobRequest
    ): IO[AwsError, zio.aws.panorama.model.DescribeDeviceJobResponse.ReadOnly] =
      asyncRequestResponse[DescribeDeviceJobRequest, DescribeDeviceJobResponse](
        "describeDeviceJob",
        api.describeDeviceJob
      )(request.buildAwsValue())
        .map(zio.aws.panorama.model.DescribeDeviceJobResponse.wrap)
        .provideEnvironment(r)
    def describePackageVersion(
        request: zio.aws.panorama.model.DescribePackageVersionRequest
    ): IO[
      AwsError,
      zio.aws.panorama.model.DescribePackageVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribePackageVersionRequest,
      DescribePackageVersionResponse
    ]("describePackageVersion", api.describePackageVersion)(
      request.buildAwsValue()
    ).map(zio.aws.panorama.model.DescribePackageVersionResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.panorama.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.panorama.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.panorama.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.panorama.model.TagResourceRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.panorama.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def deletePackage(
        request: zio.aws.panorama.model.DeletePackageRequest
    ): IO[AwsError, zio.aws.panorama.model.DeletePackageResponse.ReadOnly] =
      asyncRequestResponse[DeletePackageRequest, DeletePackageResponse](
        "deletePackage",
        api.deletePackage
      )(request.buildAwsValue())
        .map(zio.aws.panorama.model.DeletePackageResponse.wrap)
        .provideEnvironment(r)
    def listNodeFromTemplateJobs(
        request: zio.aws.panorama.model.ListNodeFromTemplateJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.panorama.model.NodeFromTemplateJob.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListNodeFromTemplateJobsRequest,
      ListNodeFromTemplateJobsResponse,
      NodeFromTemplateJob
    ](
      "listNodeFromTemplateJobs",
      api.listNodeFromTemplateJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.nodeFromTemplateJobs().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.panorama.model.NodeFromTemplateJob.wrap(item))
      .provideEnvironment(r)
    def listNodeFromTemplateJobsPaginated(
        request: zio.aws.panorama.model.ListNodeFromTemplateJobsRequest
    ): IO[
      AwsError,
      zio.aws.panorama.model.ListNodeFromTemplateJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListNodeFromTemplateJobsRequest,
      ListNodeFromTemplateJobsResponse
    ]("listNodeFromTemplateJobs", api.listNodeFromTemplateJobs)(
      request.buildAwsValue()
    ).map(zio.aws.panorama.model.ListNodeFromTemplateJobsResponse.wrap)
      .provideEnvironment(r)
    def createApplicationInstance(
        request: zio.aws.panorama.model.CreateApplicationInstanceRequest
    ): IO[
      AwsError,
      zio.aws.panorama.model.CreateApplicationInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateApplicationInstanceRequest,
      CreateApplicationInstanceResponse
    ]("createApplicationInstance", api.createApplicationInstance)(
      request.buildAwsValue()
    ).map(zio.aws.panorama.model.CreateApplicationInstanceResponse.wrap)
      .provideEnvironment(r)
    def listApplicationInstanceDependencies(
        request: zio.aws.panorama.model.ListApplicationInstanceDependenciesRequest
    ): ZStream[Any, AwsError, zio.aws.panorama.model.PackageObject.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListApplicationInstanceDependenciesRequest,
        ListApplicationInstanceDependenciesResponse,
        PackageObject
      ](
        "listApplicationInstanceDependencies",
        api.listApplicationInstanceDependencies,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.packageObjects().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.panorama.model.PackageObject.wrap(item))
        .provideEnvironment(r)
    def listApplicationInstanceDependenciesPaginated(
        request: zio.aws.panorama.model.ListApplicationInstanceDependenciesRequest
    ): IO[
      AwsError,
      zio.aws.panorama.model.ListApplicationInstanceDependenciesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListApplicationInstanceDependenciesRequest,
      ListApplicationInstanceDependenciesResponse
    ](
      "listApplicationInstanceDependencies",
      api.listApplicationInstanceDependencies
    )(request.buildAwsValue())
      .map(
        zio.aws.panorama.model.ListApplicationInstanceDependenciesResponse.wrap
      )
      .provideEnvironment(r)
    def describeApplicationInstanceDetails(
        request: zio.aws.panorama.model.DescribeApplicationInstanceDetailsRequest
    ): IO[
      AwsError,
      zio.aws.panorama.model.DescribeApplicationInstanceDetailsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeApplicationInstanceDetailsRequest,
      DescribeApplicationInstanceDetailsResponse
    ](
      "describeApplicationInstanceDetails",
      api.describeApplicationInstanceDetails
    )(request.buildAwsValue())
      .map(
        zio.aws.panorama.model.DescribeApplicationInstanceDetailsResponse.wrap
      )
      .provideEnvironment(r)
    def registerPackageVersion(
        request: zio.aws.panorama.model.RegisterPackageVersionRequest
    ): IO[
      AwsError,
      zio.aws.panorama.model.RegisterPackageVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      RegisterPackageVersionRequest,
      RegisterPackageVersionResponse
    ]("registerPackageVersion", api.registerPackageVersion)(
      request.buildAwsValue()
    ).map(zio.aws.panorama.model.RegisterPackageVersionResponse.wrap)
      .provideEnvironment(r)
    def describeApplicationInstance(
        request: zio.aws.panorama.model.DescribeApplicationInstanceRequest
    ): IO[
      AwsError,
      zio.aws.panorama.model.DescribeApplicationInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeApplicationInstanceRequest,
      DescribeApplicationInstanceResponse
    ]("describeApplicationInstance", api.describeApplicationInstance)(
      request.buildAwsValue()
    ).map(zio.aws.panorama.model.DescribeApplicationInstanceResponse.wrap)
      .provideEnvironment(r)
    def updateDeviceMetadata(
        request: zio.aws.panorama.model.UpdateDeviceMetadataRequest
    ): IO[
      AwsError,
      zio.aws.panorama.model.UpdateDeviceMetadataResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateDeviceMetadataRequest,
      UpdateDeviceMetadataResponse
    ]("updateDeviceMetadata", api.updateDeviceMetadata)(request.buildAwsValue())
      .map(zio.aws.panorama.model.UpdateDeviceMetadataResponse.wrap)
      .provideEnvironment(r)
    def listNodes(
        request: zio.aws.panorama.model.ListNodesRequest
    ): ZStream[Any, AwsError, zio.aws.panorama.model.Node.ReadOnly] =
      asyncSimplePaginatedRequest[ListNodesRequest, ListNodesResponse, Node](
        "listNodes",
        api.listNodes,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.nodes().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.panorama.model.Node.wrap(item))
        .provideEnvironment(r)
    def listNodesPaginated(
        request: zio.aws.panorama.model.ListNodesRequest
    ): IO[AwsError, zio.aws.panorama.model.ListNodesResponse.ReadOnly] =
      asyncRequestResponse[ListNodesRequest, ListNodesResponse](
        "listNodes",
        api.listNodes
      )(request.buildAwsValue())
        .map(zio.aws.panorama.model.ListNodesResponse.wrap)
        .provideEnvironment(r)
    def listPackages(
        request: zio.aws.panorama.model.ListPackagesRequest
    ): ZStream[Any, AwsError, zio.aws.panorama.model.PackageListItem.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListPackagesRequest,
        ListPackagesResponse,
        PackageListItem
      ](
        "listPackages",
        api.listPackages,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.packages().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.panorama.model.PackageListItem.wrap(item))
        .provideEnvironment(r)
    def listPackagesPaginated(
        request: zio.aws.panorama.model.ListPackagesRequest
    ): IO[AwsError, zio.aws.panorama.model.ListPackagesResponse.ReadOnly] =
      asyncRequestResponse[ListPackagesRequest, ListPackagesResponse](
        "listPackages",
        api.listPackages
      )(request.buildAwsValue())
        .map(zio.aws.panorama.model.ListPackagesResponse.wrap)
        .provideEnvironment(r)
    def describeNodeFromTemplateJob(
        request: zio.aws.panorama.model.DescribeNodeFromTemplateJobRequest
    ): IO[
      AwsError,
      zio.aws.panorama.model.DescribeNodeFromTemplateJobResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeNodeFromTemplateJobRequest,
      DescribeNodeFromTemplateJobResponse
    ]("describeNodeFromTemplateJob", api.describeNodeFromTemplateJob)(
      request.buildAwsValue()
    ).map(zio.aws.panorama.model.DescribeNodeFromTemplateJobResponse.wrap)
      .provideEnvironment(r)
  }
  def provisionDevice(
      request: zio.aws.panorama.model.ProvisionDeviceRequest
  ): ZIO[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.ProvisionDeviceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.provisionDevice(request))
  def createPackage(request: zio.aws.panorama.model.CreatePackageRequest): ZIO[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.CreatePackageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPackage(request))
  def describeDevice(
      request: zio.aws.panorama.model.DescribeDeviceRequest
  ): ZIO[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.DescribeDeviceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDevice(request))
  def deleteDevice(request: zio.aws.panorama.model.DeleteDeviceRequest): ZIO[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.DeleteDeviceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDevice(request))
  def describePackageImportJob(
      request: zio.aws.panorama.model.DescribePackageImportJobRequest
  ): ZIO[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.DescribePackageImportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePackageImportJob(request))
  def listPackageImportJobs(
      request: zio.aws.panorama.model.ListPackageImportJobsRequest
  ): ZStream[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.PackageImportJob.ReadOnly
  ] = ZStream.serviceWithStream(_.listPackageImportJobs(request))
  def listPackageImportJobsPaginated(
      request: zio.aws.panorama.model.ListPackageImportJobsRequest
  ): ZIO[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.ListPackageImportJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPackageImportJobsPaginated(request))
  def signalApplicationInstanceNodeInstances(
      request: zio.aws.panorama.model.SignalApplicationInstanceNodeInstancesRequest
  ): ZIO[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.SignalApplicationInstanceNodeInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.signalApplicationInstanceNodeInstances(request))
  def listApplicationInstanceNodeInstances(
      request: zio.aws.panorama.model.ListApplicationInstanceNodeInstancesRequest
  ): ZStream[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.NodeInstance.ReadOnly
  ] = ZStream.serviceWithStream(_.listApplicationInstanceNodeInstances(request))
  def listApplicationInstanceNodeInstancesPaginated(
      request: zio.aws.panorama.model.ListApplicationInstanceNodeInstancesRequest
  ): ZIO[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.ListApplicationInstanceNodeInstancesResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.listApplicationInstanceNodeInstancesPaginated(request))
  def listDevicesJobs(
      request: zio.aws.panorama.model.ListDevicesJobsRequest
  ): ZStream[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.DeviceJob.ReadOnly
  ] = ZStream.serviceWithStream(_.listDevicesJobs(request))
  def listDevicesJobsPaginated(
      request: zio.aws.panorama.model.ListDevicesJobsRequest
  ): ZIO[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.ListDevicesJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDevicesJobsPaginated(request))
  def listDevices(request: zio.aws.panorama.model.ListDevicesRequest): ZStream[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.Device.ReadOnly
  ] = ZStream.serviceWithStream(_.listDevices(request))
  def listDevicesPaginated(
      request: zio.aws.panorama.model.ListDevicesRequest
  ): ZIO[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.ListDevicesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDevicesPaginated(request))
  def createNodeFromTemplateJob(
      request: zio.aws.panorama.model.CreateNodeFromTemplateJobRequest
  ): ZIO[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.CreateNodeFromTemplateJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createNodeFromTemplateJob(request))
  def removeApplicationInstance(
      request: zio.aws.panorama.model.RemoveApplicationInstanceRequest
  ): ZIO[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.RemoveApplicationInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeApplicationInstance(request))
  def createJobForDevices(
      request: zio.aws.panorama.model.CreateJobForDevicesRequest
  ): ZIO[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.CreateJobForDevicesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createJobForDevices(request))
  def createPackageImportJob(
      request: zio.aws.panorama.model.CreatePackageImportJobRequest
  ): ZIO[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.CreatePackageImportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPackageImportJob(request))
  def describeNode(request: zio.aws.panorama.model.DescribeNodeRequest): ZIO[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.DescribeNodeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeNode(request))
  def describePackage(
      request: zio.aws.panorama.model.DescribePackageRequest
  ): ZIO[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.DescribePackageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePackage(request))
  def untagResource(request: zio.aws.panorama.model.UntagResourceRequest): ZIO[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def deregisterPackageVersion(
      request: zio.aws.panorama.model.DeregisterPackageVersionRequest
  ): ZIO[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.DeregisterPackageVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deregisterPackageVersion(request))
  def listApplicationInstances(
      request: zio.aws.panorama.model.ListApplicationInstancesRequest
  ): ZStream[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.ApplicationInstance.ReadOnly
  ] = ZStream.serviceWithStream(_.listApplicationInstances(request))
  def listApplicationInstancesPaginated(
      request: zio.aws.panorama.model.ListApplicationInstancesRequest
  ): ZIO[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.ListApplicationInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listApplicationInstancesPaginated(request))
  def describeDeviceJob(
      request: zio.aws.panorama.model.DescribeDeviceJobRequest
  ): ZIO[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.DescribeDeviceJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDeviceJob(request))
  def describePackageVersion(
      request: zio.aws.panorama.model.DescribePackageVersionRequest
  ): ZIO[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.DescribePackageVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePackageVersion(request))
  def listTagsForResource(
      request: zio.aws.panorama.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(
      request: zio.aws.panorama.model.TagResourceRequest
  ): ZIO[zio.aws.panorama.Panorama, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def deletePackage(request: zio.aws.panorama.model.DeletePackageRequest): ZIO[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.DeletePackageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deletePackage(request))
  def listNodeFromTemplateJobs(
      request: zio.aws.panorama.model.ListNodeFromTemplateJobsRequest
  ): ZStream[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.NodeFromTemplateJob.ReadOnly
  ] = ZStream.serviceWithStream(_.listNodeFromTemplateJobs(request))
  def listNodeFromTemplateJobsPaginated(
      request: zio.aws.panorama.model.ListNodeFromTemplateJobsRequest
  ): ZIO[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.ListNodeFromTemplateJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listNodeFromTemplateJobsPaginated(request))
  def createApplicationInstance(
      request: zio.aws.panorama.model.CreateApplicationInstanceRequest
  ): ZIO[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.CreateApplicationInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createApplicationInstance(request))
  def listApplicationInstanceDependencies(
      request: zio.aws.panorama.model.ListApplicationInstanceDependenciesRequest
  ): ZStream[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.PackageObject.ReadOnly
  ] = ZStream.serviceWithStream(_.listApplicationInstanceDependencies(request))
  def listApplicationInstanceDependenciesPaginated(
      request: zio.aws.panorama.model.ListApplicationInstanceDependenciesRequest
  ): ZIO[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.ListApplicationInstanceDependenciesResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.listApplicationInstanceDependenciesPaginated(request))
  def describeApplicationInstanceDetails(
      request: zio.aws.panorama.model.DescribeApplicationInstanceDetailsRequest
  ): ZIO[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.DescribeApplicationInstanceDetailsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeApplicationInstanceDetails(request))
  def registerPackageVersion(
      request: zio.aws.panorama.model.RegisterPackageVersionRequest
  ): ZIO[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.RegisterPackageVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerPackageVersion(request))
  def describeApplicationInstance(
      request: zio.aws.panorama.model.DescribeApplicationInstanceRequest
  ): ZIO[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.DescribeApplicationInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeApplicationInstance(request))
  def updateDeviceMetadata(
      request: zio.aws.panorama.model.UpdateDeviceMetadataRequest
  ): ZIO[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.UpdateDeviceMetadataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDeviceMetadata(request))
  def listNodes(request: zio.aws.panorama.model.ListNodesRequest): ZStream[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.Node.ReadOnly
  ] = ZStream.serviceWithStream(_.listNodes(request))
  def listNodesPaginated(request: zio.aws.panorama.model.ListNodesRequest): ZIO[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.ListNodesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listNodesPaginated(request))
  def listPackages(
      request: zio.aws.panorama.model.ListPackagesRequest
  ): ZStream[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.PackageListItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listPackages(request))
  def listPackagesPaginated(
      request: zio.aws.panorama.model.ListPackagesRequest
  ): ZIO[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.ListPackagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPackagesPaginated(request))
  def describeNodeFromTemplateJob(
      request: zio.aws.panorama.model.DescribeNodeFromTemplateJobRequest
  ): ZIO[
    zio.aws.panorama.Panorama,
    AwsError,
    zio.aws.panorama.model.DescribeNodeFromTemplateJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeNodeFromTemplateJob(request))
}
