package zio.aws.panorama
import zio.aws.panorama.model.TagResourceResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import software.amazon.awssdk.services.panorama.PanoramaAsyncClient
import zio.aws.panorama.model.{
  ListApplicationInstanceDependenciesRequest,
  ListApplicationInstancesRequest,
  ListPackagesRequest,
  DescribeDeviceRequest,
  CreatePackageImportJobRequest,
  RemoveApplicationInstanceRequest,
  ListNodesRequest,
  DescribeNodeFromTemplateJobRequest,
  DescribeApplicationInstanceRequest,
  ListApplicationInstanceNodeInstancesRequest,
  ListTagsForResourceRequest,
  RegisterPackageVersionRequest,
  DeletePackageRequest,
  CreateApplicationInstanceRequest,
  CreateNodeFromTemplateJobRequest,
  CreatePackageRequest,
  DescribePackageRequest,
  ListDevicesJobsRequest,
  ProvisionDeviceRequest,
  DescribePackageVersionRequest,
  ListPackageImportJobsRequest,
  UntagResourceRequest,
  DescribeApplicationInstanceDetailsRequest,
  DescribePackageImportJobRequest,
  SignalApplicationInstanceNodeInstancesRequest,
  ListDevicesRequest,
  DeregisterPackageVersionRequest,
  DescribeNodeRequest,
  ListNodeFromTemplateJobsRequest,
  DeleteDeviceRequest,
  CreateJobForDevicesRequest,
  TagResourceRequest,
  UpdateDeviceMetadataRequest,
  DescribeDeviceJobRequest
}
object PanoramaMock extends Mock[Panorama] {
  object ProvisionDevice
      extends Effect[
        ProvisionDeviceRequest,
        AwsError,
        zio.aws.panorama.model.ProvisionDeviceResponse.ReadOnly
      ]
  object CreatePackage
      extends Effect[
        CreatePackageRequest,
        AwsError,
        zio.aws.panorama.model.CreatePackageResponse.ReadOnly
      ]
  object DescribeDevice
      extends Effect[
        DescribeDeviceRequest,
        AwsError,
        zio.aws.panorama.model.DescribeDeviceResponse.ReadOnly
      ]
  object DeleteDevice
      extends Effect[
        DeleteDeviceRequest,
        AwsError,
        zio.aws.panorama.model.DeleteDeviceResponse.ReadOnly
      ]
  object DescribePackageImportJob
      extends Effect[
        DescribePackageImportJobRequest,
        AwsError,
        zio.aws.panorama.model.DescribePackageImportJobResponse.ReadOnly
      ]
  object ListPackageImportJobs
      extends Stream[
        ListPackageImportJobsRequest,
        AwsError,
        zio.aws.panorama.model.PackageImportJob.ReadOnly
      ]
  object ListPackageImportJobsPaginated
      extends Effect[
        ListPackageImportJobsRequest,
        AwsError,
        zio.aws.panorama.model.ListPackageImportJobsResponse.ReadOnly
      ]
  object SignalApplicationInstanceNodeInstances
      extends Effect[
        SignalApplicationInstanceNodeInstancesRequest,
        AwsError,
        zio.aws.panorama.model.SignalApplicationInstanceNodeInstancesResponse.ReadOnly
      ]
  object ListApplicationInstanceNodeInstances
      extends Stream[
        ListApplicationInstanceNodeInstancesRequest,
        AwsError,
        zio.aws.panorama.model.NodeInstance.ReadOnly
      ]
  object ListApplicationInstanceNodeInstancesPaginated
      extends Effect[
        ListApplicationInstanceNodeInstancesRequest,
        AwsError,
        zio.aws.panorama.model.ListApplicationInstanceNodeInstancesResponse.ReadOnly
      ]
  object ListDevicesJobs
      extends Stream[
        ListDevicesJobsRequest,
        AwsError,
        zio.aws.panorama.model.DeviceJob.ReadOnly
      ]
  object ListDevicesJobsPaginated
      extends Effect[
        ListDevicesJobsRequest,
        AwsError,
        zio.aws.panorama.model.ListDevicesJobsResponse.ReadOnly
      ]
  object ListDevices
      extends Stream[
        ListDevicesRequest,
        AwsError,
        zio.aws.panorama.model.Device.ReadOnly
      ]
  object ListDevicesPaginated
      extends Effect[
        ListDevicesRequest,
        AwsError,
        zio.aws.panorama.model.ListDevicesResponse.ReadOnly
      ]
  object CreateNodeFromTemplateJob
      extends Effect[
        CreateNodeFromTemplateJobRequest,
        AwsError,
        zio.aws.panorama.model.CreateNodeFromTemplateJobResponse.ReadOnly
      ]
  object RemoveApplicationInstance
      extends Effect[
        RemoveApplicationInstanceRequest,
        AwsError,
        zio.aws.panorama.model.RemoveApplicationInstanceResponse.ReadOnly
      ]
  object CreateJobForDevices
      extends Effect[
        CreateJobForDevicesRequest,
        AwsError,
        zio.aws.panorama.model.CreateJobForDevicesResponse.ReadOnly
      ]
  object CreatePackageImportJob
      extends Effect[
        CreatePackageImportJobRequest,
        AwsError,
        zio.aws.panorama.model.CreatePackageImportJobResponse.ReadOnly
      ]
  object DescribeNode
      extends Effect[
        DescribeNodeRequest,
        AwsError,
        zio.aws.panorama.model.DescribeNodeResponse.ReadOnly
      ]
  object DescribePackage
      extends Effect[
        DescribePackageRequest,
        AwsError,
        zio.aws.panorama.model.DescribePackageResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.panorama.model.UntagResourceResponse.ReadOnly
      ]
  object DeregisterPackageVersion
      extends Effect[
        DeregisterPackageVersionRequest,
        AwsError,
        zio.aws.panorama.model.DeregisterPackageVersionResponse.ReadOnly
      ]
  object ListApplicationInstances
      extends Stream[
        ListApplicationInstancesRequest,
        AwsError,
        zio.aws.panorama.model.ApplicationInstance.ReadOnly
      ]
  object ListApplicationInstancesPaginated
      extends Effect[
        ListApplicationInstancesRequest,
        AwsError,
        zio.aws.panorama.model.ListApplicationInstancesResponse.ReadOnly
      ]
  object DescribeDeviceJob
      extends Effect[
        DescribeDeviceJobRequest,
        AwsError,
        zio.aws.panorama.model.DescribeDeviceJobResponse.ReadOnly
      ]
  object DescribePackageVersion
      extends Effect[
        DescribePackageVersionRequest,
        AwsError,
        zio.aws.panorama.model.DescribePackageVersionResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.panorama.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, ReadOnly]
  object DeletePackage
      extends Effect[
        DeletePackageRequest,
        AwsError,
        zio.aws.panorama.model.DeletePackageResponse.ReadOnly
      ]
  object ListNodeFromTemplateJobs
      extends Stream[
        ListNodeFromTemplateJobsRequest,
        AwsError,
        zio.aws.panorama.model.NodeFromTemplateJob.ReadOnly
      ]
  object ListNodeFromTemplateJobsPaginated
      extends Effect[
        ListNodeFromTemplateJobsRequest,
        AwsError,
        zio.aws.panorama.model.ListNodeFromTemplateJobsResponse.ReadOnly
      ]
  object CreateApplicationInstance
      extends Effect[
        CreateApplicationInstanceRequest,
        AwsError,
        zio.aws.panorama.model.CreateApplicationInstanceResponse.ReadOnly
      ]
  object ListApplicationInstanceDependencies
      extends Stream[
        ListApplicationInstanceDependenciesRequest,
        AwsError,
        zio.aws.panorama.model.PackageObject.ReadOnly
      ]
  object ListApplicationInstanceDependenciesPaginated
      extends Effect[
        ListApplicationInstanceDependenciesRequest,
        AwsError,
        zio.aws.panorama.model.ListApplicationInstanceDependenciesResponse.ReadOnly
      ]
  object DescribeApplicationInstanceDetails
      extends Effect[
        DescribeApplicationInstanceDetailsRequest,
        AwsError,
        zio.aws.panorama.model.DescribeApplicationInstanceDetailsResponse.ReadOnly
      ]
  object RegisterPackageVersion
      extends Effect[
        RegisterPackageVersionRequest,
        AwsError,
        zio.aws.panorama.model.RegisterPackageVersionResponse.ReadOnly
      ]
  object DescribeApplicationInstance
      extends Effect[
        DescribeApplicationInstanceRequest,
        AwsError,
        zio.aws.panorama.model.DescribeApplicationInstanceResponse.ReadOnly
      ]
  object UpdateDeviceMetadata
      extends Effect[
        UpdateDeviceMetadataRequest,
        AwsError,
        zio.aws.panorama.model.UpdateDeviceMetadataResponse.ReadOnly
      ]
  object ListNodes
      extends Stream[
        ListNodesRequest,
        AwsError,
        zio.aws.panorama.model.Node.ReadOnly
      ]
  object ListNodesPaginated
      extends Effect[
        ListNodesRequest,
        AwsError,
        zio.aws.panorama.model.ListNodesResponse.ReadOnly
      ]
  object ListPackages
      extends Stream[
        ListPackagesRequest,
        AwsError,
        zio.aws.panorama.model.PackageListItem.ReadOnly
      ]
  object ListPackagesPaginated
      extends Effect[
        ListPackagesRequest,
        AwsError,
        zio.aws.panorama.model.ListPackagesResponse.ReadOnly
      ]
  object DescribeNodeFromTemplateJob
      extends Effect[
        DescribeNodeFromTemplateJobRequest,
        AwsError,
        zio.aws.panorama.model.DescribeNodeFromTemplateJobResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Panorama] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Panorama] { rts =>
        zio.ZIO.succeed {
          new Panorama {
            val api: PanoramaAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Panorama = this
            def provisionDevice(request: ProvisionDeviceRequest): IO[
              AwsError,
              zio.aws.panorama.model.ProvisionDeviceResponse.ReadOnly
            ] = proxy(ProvisionDevice, request)
            def createPackage(request: CreatePackageRequest): IO[
              AwsError,
              zio.aws.panorama.model.CreatePackageResponse.ReadOnly
            ] = proxy(CreatePackage, request)
            def describeDevice(request: DescribeDeviceRequest): IO[
              AwsError,
              zio.aws.panorama.model.DescribeDeviceResponse.ReadOnly
            ] = proxy(DescribeDevice, request)
            def deleteDevice(request: DeleteDeviceRequest): IO[
              AwsError,
              zio.aws.panorama.model.DeleteDeviceResponse.ReadOnly
            ] = proxy(DeleteDevice, request)
            def describePackageImportJob(
                request: DescribePackageImportJobRequest
            ): IO[
              AwsError,
              zio.aws.panorama.model.DescribePackageImportJobResponse.ReadOnly
            ] = proxy(DescribePackageImportJob, request)
            def listPackageImportJobs(
                request: ListPackageImportJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.panorama.model.PackageImportJob.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListPackageImportJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listPackageImportJobsPaginated(
                request: ListPackageImportJobsRequest
            ): IO[
              AwsError,
              zio.aws.panorama.model.ListPackageImportJobsResponse.ReadOnly
            ] = proxy(ListPackageImportJobsPaginated, request)
            def signalApplicationInstanceNodeInstances(
                request: SignalApplicationInstanceNodeInstancesRequest
            ): IO[
              AwsError,
              zio.aws.panorama.model.SignalApplicationInstanceNodeInstancesResponse.ReadOnly
            ] = proxy(SignalApplicationInstanceNodeInstances, request)
            def listApplicationInstanceNodeInstances(
                request: ListApplicationInstanceNodeInstancesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.panorama.model.NodeInstance.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListApplicationInstanceNodeInstances, request)
                }
                .getOrThrowFiberFailure()
            }
            def listApplicationInstanceNodeInstancesPaginated(
                request: ListApplicationInstanceNodeInstancesRequest
            ): IO[
              AwsError,
              zio.aws.panorama.model.ListApplicationInstanceNodeInstancesResponse.ReadOnly
            ] = proxy(ListApplicationInstanceNodeInstancesPaginated, request)
            def listDevicesJobs(request: ListDevicesJobsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.panorama.model.DeviceJob.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDevicesJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDevicesJobsPaginated(request: ListDevicesJobsRequest): IO[
              AwsError,
              zio.aws.panorama.model.ListDevicesJobsResponse.ReadOnly
            ] = proxy(ListDevicesJobsPaginated, request)
            def listDevices(
                request: ListDevicesRequest
            ): ZStream[Any, AwsError, zio.aws.panorama.model.Device.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListDevices, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listDevicesPaginated(request: ListDevicesRequest): IO[
              AwsError,
              zio.aws.panorama.model.ListDevicesResponse.ReadOnly
            ] = proxy(ListDevicesPaginated, request)
            def createNodeFromTemplateJob(
                request: CreateNodeFromTemplateJobRequest
            ): IO[
              AwsError,
              zio.aws.panorama.model.CreateNodeFromTemplateJobResponse.ReadOnly
            ] = proxy(CreateNodeFromTemplateJob, request)
            def removeApplicationInstance(
                request: RemoveApplicationInstanceRequest
            ): IO[
              AwsError,
              zio.aws.panorama.model.RemoveApplicationInstanceResponse.ReadOnly
            ] = proxy(RemoveApplicationInstance, request)
            def createJobForDevices(request: CreateJobForDevicesRequest): IO[
              AwsError,
              zio.aws.panorama.model.CreateJobForDevicesResponse.ReadOnly
            ] = proxy(CreateJobForDevices, request)
            def createPackageImportJob(
                request: CreatePackageImportJobRequest
            ): IO[
              AwsError,
              zio.aws.panorama.model.CreatePackageImportJobResponse.ReadOnly
            ] = proxy(CreatePackageImportJob, request)
            def describeNode(request: DescribeNodeRequest): IO[
              AwsError,
              zio.aws.panorama.model.DescribeNodeResponse.ReadOnly
            ] = proxy(DescribeNode, request)
            def describePackage(request: DescribePackageRequest): IO[
              AwsError,
              zio.aws.panorama.model.DescribePackageResponse.ReadOnly
            ] = proxy(DescribePackage, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.panorama.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def deregisterPackageVersion(
                request: DeregisterPackageVersionRequest
            ): IO[
              AwsError,
              zio.aws.panorama.model.DeregisterPackageVersionResponse.ReadOnly
            ] = proxy(DeregisterPackageVersion, request)
            def listApplicationInstances(
                request: ListApplicationInstancesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.panorama.model.ApplicationInstance.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListApplicationInstances, request)
                }
                .getOrThrowFiberFailure()
            }
            def listApplicationInstancesPaginated(
                request: ListApplicationInstancesRequest
            ): IO[
              AwsError,
              zio.aws.panorama.model.ListApplicationInstancesResponse.ReadOnly
            ] = proxy(ListApplicationInstancesPaginated, request)
            def describeDeviceJob(request: DescribeDeviceJobRequest): IO[
              AwsError,
              zio.aws.panorama.model.DescribeDeviceJobResponse.ReadOnly
            ] = proxy(DescribeDeviceJob, request)
            def describePackageVersion(
                request: DescribePackageVersionRequest
            ): IO[
              AwsError,
              zio.aws.panorama.model.DescribePackageVersionResponse.ReadOnly
            ] = proxy(DescribePackageVersion, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.panorama.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(
                request: TagResourceRequest
            ): IO[AwsError, ReadOnly] = proxy(TagResource, request)
            def deletePackage(request: DeletePackageRequest): IO[
              AwsError,
              zio.aws.panorama.model.DeletePackageResponse.ReadOnly
            ] = proxy(DeletePackage, request)
            def listNodeFromTemplateJobs(
                request: ListNodeFromTemplateJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.panorama.model.NodeFromTemplateJob.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListNodeFromTemplateJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listNodeFromTemplateJobsPaginated(
                request: ListNodeFromTemplateJobsRequest
            ): IO[
              AwsError,
              zio.aws.panorama.model.ListNodeFromTemplateJobsResponse.ReadOnly
            ] = proxy(ListNodeFromTemplateJobsPaginated, request)
            def createApplicationInstance(
                request: CreateApplicationInstanceRequest
            ): IO[
              AwsError,
              zio.aws.panorama.model.CreateApplicationInstanceResponse.ReadOnly
            ] = proxy(CreateApplicationInstance, request)
            def listApplicationInstanceDependencies(
                request: ListApplicationInstanceDependenciesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.panorama.model.PackageObject.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListApplicationInstanceDependencies, request)
                }
                .getOrThrowFiberFailure()
            }
            def listApplicationInstanceDependenciesPaginated(
                request: ListApplicationInstanceDependenciesRequest
            ): IO[
              AwsError,
              zio.aws.panorama.model.ListApplicationInstanceDependenciesResponse.ReadOnly
            ] = proxy(ListApplicationInstanceDependenciesPaginated, request)
            def describeApplicationInstanceDetails(
                request: DescribeApplicationInstanceDetailsRequest
            ): IO[
              AwsError,
              zio.aws.panorama.model.DescribeApplicationInstanceDetailsResponse.ReadOnly
            ] = proxy(DescribeApplicationInstanceDetails, request)
            def registerPackageVersion(
                request: RegisterPackageVersionRequest
            ): IO[
              AwsError,
              zio.aws.panorama.model.RegisterPackageVersionResponse.ReadOnly
            ] = proxy(RegisterPackageVersion, request)
            def describeApplicationInstance(
                request: DescribeApplicationInstanceRequest
            ): IO[
              AwsError,
              zio.aws.panorama.model.DescribeApplicationInstanceResponse.ReadOnly
            ] = proxy(DescribeApplicationInstance, request)
            def updateDeviceMetadata(request: UpdateDeviceMetadataRequest): IO[
              AwsError,
              zio.aws.panorama.model.UpdateDeviceMetadataResponse.ReadOnly
            ] = proxy(UpdateDeviceMetadata, request)
            def listNodes(
                request: ListNodesRequest
            ): ZStream[Any, AwsError, zio.aws.panorama.model.Node.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListNodes, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listNodesPaginated(
                request: ListNodesRequest
            ): IO[AwsError, zio.aws.panorama.model.ListNodesResponse.ReadOnly] =
              proxy(ListNodesPaginated, request)
            def listPackages(request: ListPackagesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.panorama.model.PackageListItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListPackages, request)
                }
                .getOrThrowFiberFailure()
            }
            def listPackagesPaginated(request: ListPackagesRequest): IO[
              AwsError,
              zio.aws.panorama.model.ListPackagesResponse.ReadOnly
            ] = proxy(ListPackagesPaginated, request)
            def describeNodeFromTemplateJob(
                request: DescribeNodeFromTemplateJobRequest
            ): IO[
              AwsError,
              zio.aws.panorama.model.DescribeNodeFromTemplateJobResponse.ReadOnly
            ] = proxy(DescribeNodeFromTemplateJob, request)
          }
        }
      }
    }
  }
}
