package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.Version
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AlternateSoftwareMetadata(
    version: Optional[Version] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.AlternateSoftwareMetadata = {
    import AlternateSoftwareMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.AlternateSoftwareMetadata
      .builder()
      .optionallyWith(
        version.map(value => Version.unwrap(value): java.lang.String)
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.AlternateSoftwareMetadata.ReadOnly =
    zio.aws.panorama.model.AlternateSoftwareMetadata.wrap(buildAwsValue())
}
object AlternateSoftwareMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.AlternateSoftwareMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.AlternateSoftwareMetadata =
      zio.aws.panorama.model
        .AlternateSoftwareMetadata(version.map(value => value))
    def version: Optional[Version]
    def getVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.AlternateSoftwareMetadata
  ) extends zio.aws.panorama.model.AlternateSoftwareMetadata.ReadOnly {
    override val version: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.panorama.model.primitives.Version(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.AlternateSoftwareMetadata
  ): zio.aws.panorama.model.AlternateSoftwareMetadata.ReadOnly = new Wrapper(
    impl
  )
}
