package zio.aws.panorama.model
import scala.jdk.CollectionConverters._
sealed trait ApplicationInstanceHealthStatus {
  def unwrap: software.amazon.awssdk.services.panorama.model.ApplicationInstanceHealthStatus
}
object ApplicationInstanceHealthStatus {
  def wrap(
      value: software.amazon.awssdk.services.panorama.model.ApplicationInstanceHealthStatus
  ): zio.aws.panorama.model.ApplicationInstanceHealthStatus = value match {
    case software.amazon.awssdk.services.panorama.model.ApplicationInstanceHealthStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.panorama.model.ApplicationInstanceHealthStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.panorama.model.ApplicationInstanceHealthStatus.ERROR =>
      val r = ERROR
      r
    case software.amazon.awssdk.services.panorama.model.ApplicationInstanceHealthStatus.NOT_AVAILABLE =>
      val r = NOT_AVAILABLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.panorama.model.ApplicationInstanceHealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.ApplicationInstanceHealthStatus =
      software.amazon.awssdk.services.panorama.model.ApplicationInstanceHealthStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object RUNNING
      extends zio.aws.panorama.model.ApplicationInstanceHealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.ApplicationInstanceHealthStatus =
      software.amazon.awssdk.services.panorama.model.ApplicationInstanceHealthStatus.RUNNING
  }
  case object ERROR
      extends zio.aws.panorama.model.ApplicationInstanceHealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.ApplicationInstanceHealthStatus =
      software.amazon.awssdk.services.panorama.model.ApplicationInstanceHealthStatus.ERROR
  }
  case object NOT_AVAILABLE
      extends zio.aws.panorama.model.ApplicationInstanceHealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.ApplicationInstanceHealthStatus =
      software.amazon.awssdk.services.panorama.model.ApplicationInstanceHealthStatus.NOT_AVAILABLE
  }
}
