package zio.aws.panorama.model
import scala.jdk.CollectionConverters._
sealed trait ApplicationInstanceStatus {
  def unwrap
      : software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus
}
object ApplicationInstanceStatus {
  def wrap(
      value: software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus
  ): zio.aws.panorama.model.ApplicationInstanceStatus = value match {
    case software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus.DEPLOYMENT_PENDING =>
      val r = DEPLOYMENT_PENDING
      r
    case software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus.DEPLOYMENT_REQUESTED =>
      val r = DEPLOYMENT_REQUESTED
      r
    case software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus.DEPLOYMENT_IN_PROGRESS =>
      val r = DEPLOYMENT_IN_PROGRESS
      r
    case software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus.DEPLOYMENT_ERROR =>
      val r = DEPLOYMENT_ERROR
      r
    case software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus.DEPLOYMENT_SUCCEEDED =>
      val r = DEPLOYMENT_SUCCEEDED
      r
    case software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus.REMOVAL_PENDING =>
      val r = REMOVAL_PENDING
      r
    case software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus.REMOVAL_REQUESTED =>
      val r = REMOVAL_REQUESTED
      r
    case software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus.REMOVAL_IN_PROGRESS =>
      val r = REMOVAL_IN_PROGRESS
      r
    case software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus.REMOVAL_FAILED =>
      val r = REMOVAL_FAILED
      r
    case software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus.REMOVAL_SUCCEEDED =>
      val r = REMOVAL_SUCCEEDED
      r
    case software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus.DEPLOYMENT_FAILED =>
      val r = DEPLOYMENT_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.panorama.model.ApplicationInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus =
      software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object DEPLOYMENT_PENDING
      extends zio.aws.panorama.model.ApplicationInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus =
      software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus.DEPLOYMENT_PENDING
  }
  case object DEPLOYMENT_REQUESTED
      extends zio.aws.panorama.model.ApplicationInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus =
      software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus.DEPLOYMENT_REQUESTED
  }
  case object DEPLOYMENT_IN_PROGRESS
      extends zio.aws.panorama.model.ApplicationInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus =
      software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus.DEPLOYMENT_IN_PROGRESS
  }
  case object DEPLOYMENT_ERROR
      extends zio.aws.panorama.model.ApplicationInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus =
      software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus.DEPLOYMENT_ERROR
  }
  case object DEPLOYMENT_SUCCEEDED
      extends zio.aws.panorama.model.ApplicationInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus =
      software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus.DEPLOYMENT_SUCCEEDED
  }
  case object REMOVAL_PENDING
      extends zio.aws.panorama.model.ApplicationInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus =
      software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus.REMOVAL_PENDING
  }
  case object REMOVAL_REQUESTED
      extends zio.aws.panorama.model.ApplicationInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus =
      software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus.REMOVAL_REQUESTED
  }
  case object REMOVAL_IN_PROGRESS
      extends zio.aws.panorama.model.ApplicationInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus =
      software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus.REMOVAL_IN_PROGRESS
  }
  case object REMOVAL_FAILED
      extends zio.aws.panorama.model.ApplicationInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus =
      software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus.REMOVAL_FAILED
  }
  case object REMOVAL_SUCCEEDED
      extends zio.aws.panorama.model.ApplicationInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus =
      software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus.REMOVAL_SUCCEEDED
  }
  case object DEPLOYMENT_FAILED
      extends zio.aws.panorama.model.ApplicationInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus =
      software.amazon.awssdk.services.panorama.model.ApplicationInstanceStatus.DEPLOYMENT_FAILED
  }
}
