package zio.aws.panorama.model
import scala.jdk.CollectionConverters._
sealed trait ConnectionType {
  def unwrap: software.amazon.awssdk.services.panorama.model.ConnectionType
}
object ConnectionType {
  def wrap(
      value: software.amazon.awssdk.services.panorama.model.ConnectionType
  ): zio.aws.panorama.model.ConnectionType = value match {
    case software.amazon.awssdk.services.panorama.model.ConnectionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.panorama.model.ConnectionType.STATIC_IP =>
      val r = STATIC_IP
      r
    case software.amazon.awssdk.services.panorama.model.ConnectionType.DHCP =>
      val r = DHCP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.panorama.model.ConnectionType {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.ConnectionType =
      software.amazon.awssdk.services.panorama.model.ConnectionType.UNKNOWN_TO_SDK_VERSION
  }
  case object STATIC_IP extends zio.aws.panorama.model.ConnectionType {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.ConnectionType =
      software.amazon.awssdk.services.panorama.model.ConnectionType.STATIC_IP
  }
  case object DHCP extends zio.aws.panorama.model.ConnectionType {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.ConnectionType =
      software.amazon.awssdk.services.panorama.model.ConnectionType.DHCP
  }
}
