package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.{
  ApplicationInstanceName,
  TagValue,
  Description,
  RuntimeRoleArn,
  ApplicationInstanceId,
  DefaultRuntimeContextDevice,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateApplicationInstanceRequest(
    applicationInstanceIdToReplace: Optional[ApplicationInstanceId] =
      Optional.Absent,
    defaultRuntimeContextDevice: DefaultRuntimeContextDevice,
    description: Optional[Description] = Optional.Absent,
    manifestOverridesPayload: Optional[
      zio.aws.panorama.model.ManifestOverridesPayload
    ] = Optional.Absent,
    manifestPayload: zio.aws.panorama.model.ManifestPayload,
    name: Optional[ApplicationInstanceName] = Optional.Absent,
    runtimeRoleArn: Optional[RuntimeRoleArn] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.CreateApplicationInstanceRequest = {
    import CreateApplicationInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.CreateApplicationInstanceRequest
      .builder()
      .optionallyWith(
        applicationInstanceIdToReplace.map(value =>
          ApplicationInstanceId.unwrap(value): java.lang.String
        )
      )(_.applicationInstanceIdToReplace)
      .defaultRuntimeContextDevice(
        DefaultRuntimeContextDevice.unwrap(
          defaultRuntimeContextDevice
        ): java.lang.String
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        manifestOverridesPayload.map(value => value.buildAwsValue())
      )(_.manifestOverridesPayload)
      .manifestPayload(manifestPayload.buildAwsValue())
      .optionallyWith(
        name.map(value =>
          ApplicationInstanceName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        runtimeRoleArn.map(value =>
          RuntimeRoleArn.unwrap(value): java.lang.String
        )
      )(_.runtimeRoleArn)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.panorama.model.CreateApplicationInstanceRequest.ReadOnly =
    zio.aws.panorama.model.CreateApplicationInstanceRequest
      .wrap(buildAwsValue())
}
object CreateApplicationInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.CreateApplicationInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.CreateApplicationInstanceRequest =
      zio.aws.panorama.model.CreateApplicationInstanceRequest(
        applicationInstanceIdToReplace.map(value => value),
        defaultRuntimeContextDevice,
        description.map(value => value),
        manifestOverridesPayload.map(value => value.asEditable),
        manifestPayload.asEditable,
        name.map(value => value),
        runtimeRoleArn.map(value => value),
        tags.map(value => value)
      )
    def applicationInstanceIdToReplace: Optional[ApplicationInstanceId]
    def defaultRuntimeContextDevice: DefaultRuntimeContextDevice
    def description: Optional[Description]
    def manifestOverridesPayload
        : Optional[zio.aws.panorama.model.ManifestOverridesPayload.ReadOnly]
    def manifestPayload: zio.aws.panorama.model.ManifestPayload.ReadOnly
    def name: Optional[ApplicationInstanceName]
    def runtimeRoleArn: Optional[RuntimeRoleArn]
    def tags: Optional[Map[TagKey, TagValue]]
    def getApplicationInstanceIdToReplace
        : ZIO[Any, AwsError, ApplicationInstanceId] =
      AwsError.unwrapOptionField(
        "applicationInstanceIdToReplace",
        applicationInstanceIdToReplace
      )
    def getDefaultRuntimeContextDevice
        : ZIO[Any, Nothing, DefaultRuntimeContextDevice] =
      ZIO.succeed(defaultRuntimeContextDevice)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getManifestOverridesPayload: ZIO[
      Any,
      AwsError,
      zio.aws.panorama.model.ManifestOverridesPayload.ReadOnly
    ] = AwsError.unwrapOptionField(
      "manifestOverridesPayload",
      manifestOverridesPayload
    )
    def getManifestPayload
        : ZIO[Any, Nothing, zio.aws.panorama.model.ManifestPayload.ReadOnly] =
      ZIO.succeed(manifestPayload)
    def getName: ZIO[Any, AwsError, ApplicationInstanceName] =
      AwsError.unwrapOptionField("name", name)
    def getRuntimeRoleArn: ZIO[Any, AwsError, RuntimeRoleArn] =
      AwsError.unwrapOptionField("runtimeRoleArn", runtimeRoleArn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.CreateApplicationInstanceRequest
  ) extends zio.aws.panorama.model.CreateApplicationInstanceRequest.ReadOnly {
    override val applicationInstanceIdToReplace
        : Optional[ApplicationInstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationInstanceIdToReplace())
      .map(value =>
        zio.aws.panorama.model.primitives.ApplicationInstanceId(value)
      )
    override val defaultRuntimeContextDevice: DefaultRuntimeContextDevice =
      zio.aws.panorama.model.primitives
        .DefaultRuntimeContextDevice(impl.defaultRuntimeContextDevice())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.panorama.model.primitives.Description(value))
    override val manifestOverridesPayload
        : Optional[zio.aws.panorama.model.ManifestOverridesPayload.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manifestOverridesPayload())
        .map(value =>
          zio.aws.panorama.model.ManifestOverridesPayload.wrap(value)
        )
    override val manifestPayload
        : zio.aws.panorama.model.ManifestPayload.ReadOnly =
      zio.aws.panorama.model.ManifestPayload.wrap(impl.manifestPayload())
    override val name: Optional[ApplicationInstanceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.panorama.model.primitives.ApplicationInstanceName(value)
      )
    override val runtimeRoleArn: Optional[RuntimeRoleArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runtimeRoleArn())
        .map(value => zio.aws.panorama.model.primitives.RuntimeRoleArn(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.panorama.model.primitives
              .TagKey(key) -> zio.aws.panorama.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.CreateApplicationInstanceRequest
  ): zio.aws.panorama.model.CreateApplicationInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
