package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.ApplicationInstanceId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateApplicationInstanceResponse(
    applicationInstanceId: ApplicationInstanceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.CreateApplicationInstanceResponse = {
    import CreateApplicationInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.CreateApplicationInstanceResponse
      .builder()
      .applicationInstanceId(
        ApplicationInstanceId.unwrap(applicationInstanceId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.panorama.model.CreateApplicationInstanceResponse.ReadOnly =
    zio.aws.panorama.model.CreateApplicationInstanceResponse
      .wrap(buildAwsValue())
}
object CreateApplicationInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.CreateApplicationInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.CreateApplicationInstanceResponse =
      zio.aws.panorama.model
        .CreateApplicationInstanceResponse(applicationInstanceId)
    def applicationInstanceId: ApplicationInstanceId
    def getApplicationInstanceId: ZIO[Any, Nothing, ApplicationInstanceId] =
      ZIO.succeed(applicationInstanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.CreateApplicationInstanceResponse
  ) extends zio.aws.panorama.model.CreateApplicationInstanceResponse.ReadOnly {
    override val applicationInstanceId: ApplicationInstanceId =
      zio.aws.panorama.model.primitives
        .ApplicationInstanceId(impl.applicationInstanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.CreateApplicationInstanceResponse
  ): zio.aws.panorama.model.CreateApplicationInstanceResponse.ReadOnly =
    new Wrapper(impl)
}
