package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.DeviceId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateJobForDevicesRequest(
    deviceIds: Iterable[DeviceId],
    deviceJobConfig: Optional[zio.aws.panorama.model.DeviceJobConfig] =
      Optional.Absent,
    jobType: zio.aws.panorama.model.JobType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.CreateJobForDevicesRequest = {
    import CreateJobForDevicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.CreateJobForDevicesRequest
      .builder()
      .deviceIds(deviceIds.map { item =>
        DeviceId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(deviceJobConfig.map(value => value.buildAwsValue()))(
        _.deviceJobConfig
      )
      .jobType(jobType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.CreateJobForDevicesRequest.ReadOnly =
    zio.aws.panorama.model.CreateJobForDevicesRequest.wrap(buildAwsValue())
}
object CreateJobForDevicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.CreateJobForDevicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.CreateJobForDevicesRequest =
      zio.aws.panorama.model.CreateJobForDevicesRequest(
        deviceIds,
        deviceJobConfig.map(value => value.asEditable),
        jobType
      )
    def deviceIds: List[DeviceId]
    def deviceJobConfig
        : Optional[zio.aws.panorama.model.DeviceJobConfig.ReadOnly]
    def jobType: zio.aws.panorama.model.JobType
    def getDeviceIds: ZIO[Any, Nothing, List[DeviceId]] = ZIO.succeed(deviceIds)
    def getDeviceJobConfig
        : ZIO[Any, AwsError, zio.aws.panorama.model.DeviceJobConfig.ReadOnly] =
      AwsError.unwrapOptionField("deviceJobConfig", deviceJobConfig)
    def getJobType: ZIO[Any, Nothing, zio.aws.panorama.model.JobType] =
      ZIO.succeed(jobType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.CreateJobForDevicesRequest
  ) extends zio.aws.panorama.model.CreateJobForDevicesRequest.ReadOnly {
    override val deviceIds: List[DeviceId] = impl
      .deviceIds()
      .asScala
      .map { item =>
        zio.aws.panorama.model.primitives.DeviceId(item)
      }
      .toList
    override val deviceJobConfig
        : Optional[zio.aws.panorama.model.DeviceJobConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceJobConfig())
        .map(value => zio.aws.panorama.model.DeviceJobConfig.wrap(value))
    override val jobType: zio.aws.panorama.model.JobType =
      zio.aws.panorama.model.JobType.wrap(impl.jobType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.CreateJobForDevicesRequest
  ): zio.aws.panorama.model.CreateJobForDevicesRequest.ReadOnly = new Wrapper(
    impl
  )
}
